/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.model;

import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import net.caffeinemc.mods.sodium.client.model.quad.properties.ModelQuadFlags;
import net.caffeinemc.mods.sodium.client.render.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.helper.GeometryHelper;
import net.caffeinemc.mods.sodium.client.render.helper.NormalHelper;
import net.caffeinemc.mods.sodium.client.render.model.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.model.SodiumShadeMode;
import net.minecraft.class_1058;
import net.minecraft.class_11515;
import net.minecraft.class_2350;
import net.minecraft.class_5611;
import net.minecraft.class_9851;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.jspecify.annotations.Nullable;

public class QuadViewImpl
implements ModelQuadView {
    protected @Nullable class_2350 nominalFace;
    protected boolean isGeometryInvalid = true;
    protected final Vector3f faceNormal = new Vector3f();
    protected int packedNormal = NormI8.pack(0.0f, 1.0f, 0.0f);
    protected int normalFlags;
    protected int header = 0;
    protected int tintIndex = 0;
    protected final Vector3f[] positions = new Vector3f[]{new Vector3f(), new Vector3f(), new Vector3f(), new Vector3f()};
    protected long[] uv = new long[4];
    protected int[] light = new int[4];
    protected int[] colors = new int[4];
    protected int maxLightEmission;
    protected int tag;

    public void load() {
        this.isGeometryInvalid = false;
        this.nominalFace = this.getLightFace();
        NormI8.unpack(this.packedFaceNormal(), this.faceNormal);
    }

    protected void computeGeometry() {
        if (this.isGeometryInvalid) {
            int packedFaceNormal;
            this.isGeometryInvalid = false;
            NormalHelper.computeFaceNormal(this.faceNormal, this);
            this.packedNormal = packedFaceNormal = NormI8.pack((Vector3fc)this.faceNormal);
            class_2350 lightFace = GeometryHelper.lightFace(this);
            this.header = EncodingFormat.lightFace(this.header, lightFace);
            this.header = EncodingFormat.normalFace(this.header, ModelQuadFacing.fromPackedNormal(packedFaceNormal));
            this.header = EncodingFormat.geometryFlags(this.header, ModelQuadFlags.getQuadFlags(this, lightFace));
        }
    }

    public int geometryFlags() {
        this.computeGeometry();
        return EncodingFormat.geometryFlags(this.header);
    }

    public boolean hasShade() {
        return this.diffuseShade();
    }

    public Vector3f copyPos(int vertexIndex, @Nullable Vector3f target) {
        if (target == null) {
            target = new Vector3f();
        }
        target.set(this.positions[vertexIndex].x, this.positions[vertexIndex].y, this.positions[vertexIndex].z);
        return target;
    }

    public @Nullable class_11515 getRenderType() {
        return EncodingFormat.renderLayer(this.header);
    }

    public boolean emissive() {
        return EncodingFormat.emissive(this.header);
    }

    public boolean diffuseShade() {
        return EncodingFormat.diffuseShade(this.header);
    }

    public class_9851 ambientOcclusion() {
        return EncodingFormat.ambientOcclusion(this.header);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable class_10444.class_10445 glint() {
        return EncodingFormat.glint(this.header);
    }

    public SodiumShadeMode getShadeMode() {
        return EncodingFormat.shadeMode(this.header);
    }

    public int baseColor(int vertexIndex) {
        return this.colors[vertexIndex];
    }

    public Vector2f copyUv(int vertexIndex, @Nullable Vector2f target) {
        if (target == null) {
            target = new Vector2f();
        }
        target.set(class_5611.method_76641((long)this.uv[vertexIndex]), class_5611.method_76642((long)this.uv[vertexIndex]));
        return target;
    }

    public int normalFlags() {
        return EncodingFormat.normalFlags(this.header);
    }

    public boolean hasNormal(int vertexIndex) {
        return (this.normalFlags() & 1 << vertexIndex) != 0;
    }

    public boolean hasVertexNormals() {
        return this.normalFlags() != 0;
    }

    public boolean hasAllVertexNormals() {
        return (this.normalFlags() & 0xF) == 15;
    }

    public int packedNormal(int vertexIndex) {
        return this.packedNormal;
    }

    public float normalX(int vertexIndex) {
        throw new IllegalStateException("Unimplemented as of 1.21.11");
    }

    public float normalY(int vertexIndex) {
        throw new IllegalStateException("Unimplemented as of 1.21.11");
    }

    public float normalZ(int vertexIndex) {
        throw new IllegalStateException("Unimplemented as of 1.21.11");
    }

    public @Nullable Vector3f copyNormal(int vertexIndex, @Nullable Vector3f target) {
        if (this.hasNormal(vertexIndex)) {
            if (target == null) {
                target = new Vector3f();
            }
            int normal = this.packedNormal;
            NormI8.unpack(normal, target);
            return target;
        }
        return null;
    }

    public final @Nullable class_2350 getCullFace() {
        return EncodingFormat.cullFace(this.header);
    }

    public final ModelQuadFacing normalFace() {
        this.computeGeometry();
        return EncodingFormat.normalFace(this.header);
    }

    public final @Nullable class_2350 getNominalFace() {
        return this.nominalFace;
    }

    public final int packedFaceNormal() {
        this.computeGeometry();
        return this.packedNormal;
    }

    public final Vector3f faceNormal() {
        this.computeGeometry();
        return this.faceNormal;
    }

    public final int getTag() {
        return this.tag;
    }

    @Override
    public float getX(int idx) {
        return this.positions[idx].x;
    }

    @Override
    public float getY(int idx) {
        return this.positions[idx].y;
    }

    @Override
    public float getZ(int idx) {
        return this.positions[idx].z;
    }

    public float posByIndex(int vertexIndex, int coordinateIndex) {
        return this.positions[vertexIndex].get(coordinateIndex);
    }

    @Override
    public int getColor(int idx) {
        return ColorHelper.toVanillaColor(this.baseColor(idx));
    }

    @Override
    public float getTexU(int idx) {
        return class_5611.method_76641((long)this.uv[idx]);
    }

    @Override
    public float getTexV(int idx) {
        return class_5611.method_76642((long)this.uv[idx]);
    }

    @Override
    public int getVertexNormal(int idx) {
        return 0;
    }

    @Override
    public int getFaceNormal() {
        return this.packedFaceNormal();
    }

    @Override
    public int getLight(int idx) {
        return this.light[idx];
    }

    @Override
    public int getTintIndex() {
        return this.tintIndex;
    }

    @Override
    public class_1058 getSprite() {
        throw new UnsupportedOperationException("Not available for QuadViewImpl.");
    }

    @Override
    public class_2350 getLightFace() {
        this.computeGeometry();
        return EncodingFormat.lightFace(this.header);
    }

    @Override
    public int getMaxLightQuad(int idx) {
        return this.getLight(idx);
    }

    @Override
    public int getFlags() {
        return this.geometryFlags();
    }
}

