/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.chunk.shader;

import com.mojang.blaze3d.opengl.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.EnumMap;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.gl.buffer.GlBuffer;
import net.caffeinemc.mods.sodium.client.gl.device.GLRenderDevice;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformBlock;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformBool;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformFloat;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformFloat2v;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformFloat3v;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformInt;
import net.caffeinemc.mods.sodium.client.gl.shader.uniform.GlUniformMatrix4f;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderFogComponent;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderInterface;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderOptions;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ChunkShaderTextureSlot;
import net.caffeinemc.mods.sodium.client.render.chunk.shader.ShaderBindingContext;
import net.caffeinemc.mods.sodium.client.render.chunk.terrain.TerrainRenderPass;
import net.caffeinemc.mods.sodium.client.util.FogParameters;
import net.caffeinemc.mods.sodium.mixin.core.render.texture.TextureAtlasAccessor;
import net.minecraft.class_1059;
import net.minecraft.class_10868;
import net.minecraft.class_12134;
import net.minecraft.class_12137;
import net.minecraft.class_12393;
import net.minecraft.class_310;
import org.joml.Matrix4fc;
import org.lwjgl.opengl.GL33C;

public class DefaultShaderInterface
implements ChunkShaderInterface {
    private final Map<ChunkShaderTextureSlot, GlUniformInt> uniformTextures;
    private final GlUniformMatrix4f uniformModelViewMatrix;
    private final GlUniformMatrix4f uniformProjectionMatrix;
    private final GlUniformFloat3v uniformRegionOffset;
    private final GlUniformFloat2v uniformTexCoordShrink;
    private final GlUniformFloat2v uniformTexelSize;
    private final GlUniformBool uniformRGSS;
    private final GlUniformInt uniformCurrentTime;
    private final GlUniformFloat uniformFadePeriod;
    private final GlUniformBlock uniformChunkData;
    private final ChunkShaderFogComponent fogShader;

    public DefaultShaderInterface(ShaderBindingContext context, ChunkShaderOptions options) {
        this.uniformModelViewMatrix = context.bindUniform("u_ModelViewMatrix", GlUniformMatrix4f::new);
        this.uniformProjectionMatrix = context.bindUniform("u_ProjectionMatrix", GlUniformMatrix4f::new);
        this.uniformRegionOffset = context.bindUniform("u_RegionOffset", GlUniformFloat3v::new);
        this.uniformTexCoordShrink = context.bindUniform("u_TexCoordShrink", GlUniformFloat2v::new);
        this.uniformTexelSize = context.bindUniform("u_TexelSize", GlUniformFloat2v::new);
        this.uniformRGSS = context.bindUniform("u_UseRGSS", GlUniformBool::new);
        this.uniformCurrentTime = context.bindUniform("u_CurrentTime", GlUniformInt::new);
        this.uniformFadePeriod = context.bindUniform("u_FadePeriodInv", GlUniformFloat::new);
        this.uniformChunkData = context.bindUniformBlock("ChunkData", 0);
        this.uniformTextures = new EnumMap<ChunkShaderTextureSlot, GlUniformInt>(ChunkShaderTextureSlot.class);
        this.uniformTextures.put(ChunkShaderTextureSlot.BLOCK, context.bindUniform("u_BlockTex", GlUniformInt::new));
        this.uniformTextures.put(ChunkShaderTextureSlot.LIGHT, context.bindUniform("u_LightTex", GlUniformInt::new));
        this.fogShader = options.fog().getFactory().apply(context);
    }

    @Override
    public void setupState(TerrainRenderPass pass, FogParameters parameters, class_12137 terrainSampler) {
        this.bindTexture(ChunkShaderTextureSlot.BLOCK, pass.getAtlas(), terrainSampler);
        this.bindTexture(ChunkShaderTextureSlot.LIGHT, class_310.method_1551().field_1773.method_22974().method_71650(), RenderSystem.getSamplerCache().method_75294(FilterMode.LINEAR));
        TextureAtlasAccessor textureAtlas = (TextureAtlasAccessor)class_310.method_1551().method_1531().method_4619(class_1059.field_5275);
        double subTexelPrecision = 1 << GLRenderDevice.INSTANCE.getSubTexelPrecisionBits();
        double subTexelOffset = 3.0517578125E-5;
        this.uniformTexCoordShrink.set((float)(subTexelOffset - 1.0 / (double)textureAtlas.getWidth() / subTexelPrecision), (float)(subTexelOffset - 1.0 / (double)textureAtlas.getHeight() / subTexelPrecision));
        this.uniformTexelSize.set(1.0f / (float)textureAtlas.getWidth(), 1.0f / (float)textureAtlas.getHeight());
        this.uniformFadePeriod.setFloat((float)(1.0 / ((Double)class_310.method_1551().field_1690.method_76253().method_41753() * 1000.0)));
        this.uniformRGSS.setBool(class_310.method_1551().field_1690.method_76747().method_41753() == class_12393.field_64664);
        this.fogShader.setup(parameters);
    }

    @Override
    public void resetState() {
    }

    @Deprecated(forRemoval=true)
    private void bindTexture(ChunkShaderTextureSlot slot, GpuTextureView textureView, class_12137 sampler) {
        class_10868 tex = (class_10868)textureView.texture();
        GlStateManager._activeTexture((int)(33984 + slot.ordinal()));
        GlStateManager._bindTexture((int)tex.method_68427());
        GlStateManager._texParameter((int)3553, (int)33084, (int)textureView.baseMipLevel());
        GlStateManager._texParameter((int)3553, (int)33085, (int)(textureView.baseMipLevel() + textureView.mipLevels() - 1));
        GL33C.glBindSampler((int)slot.ordinal(), (int)((class_12134)sampler).method_75285());
        GlUniformInt uniform = this.uniformTextures.get((Object)slot);
        uniform.setInt(slot.ordinal());
    }

    @Override
    public void setChunkData(GlBuffer data, int time) {
        this.uniformChunkData.bindBuffer(data);
        this.uniformCurrentTime.set(time);
    }

    @Override
    public void setProjectionMatrix(Matrix4fc matrix) {
        this.uniformProjectionMatrix.set(matrix);
    }

    @Override
    public void setModelViewMatrix(Matrix4fc matrix) {
        this.uniformModelViewMatrix.set(matrix);
    }

    @Override
    public void setRegionOffset(float x, float y, float z) {
        this.uniformRegionOffset.set(x, y, z);
    }
}

