/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.widgets;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.caffeinemc.mods.sodium.client.config.ConfigManager;
import net.caffeinemc.mods.sodium.client.config.search.SearchQuerySession;
import net.caffeinemc.mods.sodium.client.config.search.TextSource;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.gui.widgets.AbstractParentWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.FlatButtonWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import org.jspecify.annotations.NonNull;

public class SearchWidget
extends AbstractParentWidget {
    private static final int MAX_ORDER_DIST_ERROR = 2;
    private final Consumer<List<Option.OptionNameSource>> onSearchResults;
    private final SearchQuerySession searchQuerySession;
    private String query = "";
    private class_342 searchBox;
    private FlatButtonWidget clearButton;
    private int lastRebuildWidth = -1;

    public SearchWidget(Consumer<List<Option.OptionNameSource>> onSearchResults, Dim2i dim) {
        super(dim);
        this.onSearchResults = onSearchResults;
        this.searchQuerySession = ConfigManager.CONFIG.startSearchQuery();
    }

    public void updateWidgetWidth(int width) {
        if (width != this.lastRebuildWidth) {
            this.lastRebuildWidth = width;
            this.rebuildForWidth(width);
        }
    }

    private void rebuildForWidth(int width) {
        this.clearChildren();
        int x = this.getX();
        int y = this.getY();
        int searchBoxWidth = width - 20;
        this.clearButton = new FlatButtonWidget(new Dim2i(x + searchBoxWidth, y, 20, 20), (class_2561)class_2561.method_43470((String)"\u00d7"), this::clearSearch, true, false);
        Objects.requireNonNull(this.font);
        this.searchBox = new class_342(this.font, x + 5, y + 10 - 9 / 2, searchBoxWidth - 20, 20, (class_2561)class_2561.method_43471((String)"sodium.options.search"));
        this.searchBox.method_1880(200);
        this.searchBox.method_1858(false);
        this.searchBox.method_1863(this::triggerSearch);
        this.searchBox.method_47404((class_2561)class_2561.method_43471((String)"sodium.options.search.hint"));
        this.addChild(this.searchBox);
        this.addChild(this.clearButton);
    }

    private void clearSearch() {
        this.searchBox.method_1852("");
        this.query = "";
        this.search();
        this.method_25395(null);
    }

    private void triggerSearch(String text) {
        if (text.equals(this.query)) {
            return;
        }
        this.query = text.stripLeading();
        this.search();
    }

    private void search() {
        List<? extends TextSource> results = this.searchQuerySession.getSearchResults(this.query);
        for (int i = 0; i < results.size(); ++i) {
            TextSource result = results.get(i);
            result.setResultIndex(i);
            if (result instanceof Option.OptionNameSource) continue;
            throw new UnsupportedOperationException("Unsupported search text source type: " + result.getClass().getName());
        }
        List<? extends TextSource> typedResults = results;
        this.improveGrouping(typedResults);
        this.onSearchResults.accept(typedResults);
    }

    private void improveGrouping(List<Option.OptionNameSource> searchResults) {
        int length = searchResults.size();
        for (int i = 1; i < length - 1; ++i) {
            Option.OptionNameSource prev = searchResults.get(i - 1);
            Option.OptionNameSource curr = searchResults.get(i);
            Option.OptionNameSource next = searchResults.get(i + 1);
            if (Math.abs(i - prev.getResultIndex()) > 2 || Math.abs(i + 1 - next.getResultIndex()) > 2) continue;
            int prevCurrScore = this.getGroupScore(prev, curr);
            int prevNextScore = this.getGroupScore(prev, next);
            if (prevNextScore <= prevCurrScore) continue;
            searchResults.set(i, next);
            searchResults.set(i + 1, curr);
        }
    }

    private int getGroupScore(Option.OptionNameSource a, Option.OptionNameSource b) {
        if (a.getModOptions() != b.getModOptions()) {
            return 0;
        }
        if (a.getPage() != b.getPage()) {
            return 1;
        }
        if (a.getOptionGroup() != b.getOptionGroup()) {
            return 2;
        }
        return 3;
    }

    @Override
    public void method_25394(@NonNull class_332 graphics, int mouseX, int mouseY, float delta) {
        graphics.method_25294(this.getX(), this.getY(), this.getX() + this.lastRebuildWidth - 20, this.getLimitY(), -1879048192);
        this.searchBox.method_25394(graphics, mouseX, mouseY, delta);
        this.clearButton.method_25394(graphics, mouseX, mouseY, delta);
        super.method_25394(graphics, mouseX, mouseY, delta);
    }

    public boolean method_25404(class_11908 event) {
        if (event.method_74231() && this.method_25399() == this.searchBox) {
            this.clearSearch();
            return true;
        }
        return super.method_25404(event);
    }

    public boolean method_25400(class_11905 event) {
        return this.searchBox.method_25400(event);
    }

    public boolean isSearching() {
        return this.searchBox.method_25370();
    }

    @Override
    public void method_25365(boolean focused) {
        super.method_25365(focused);
        if (focused) {
            this.method_25395((class_364)this.searchBox);
        }
    }
}

