/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.widgets;

import it.unimi.dsi.fastutil.objects.Reference2ReferenceMap;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.Objects;
import net.caffeinemc.mods.sodium.client.config.ConfigManager;
import net.caffeinemc.mods.sodium.client.config.structure.ExternalPage;
import net.caffeinemc.mods.sodium.client.config.structure.ModOptions;
import net.caffeinemc.mods.sodium.client.config.structure.OptionPage;
import net.caffeinemc.mods.sodium.client.config.structure.Page;
import net.caffeinemc.mods.sodium.client.gui.ColorTheme;
import net.caffeinemc.mods.sodium.client.gui.VideoSettingsScreen;
import net.caffeinemc.mods.sodium.client.gui.options.control.AbstractScrollable;
import net.caffeinemc.mods.sodium.client.gui.widgets.CenteredFlatWidget;
import net.caffeinemc.mods.sodium.client.gui.widgets.ScrollbarWidget;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import org.jspecify.annotations.NonNull;

public class PageListWidget
extends AbstractScrollable {
    private final VideoSettingsScreen parent;
    private EntryWidget selected;
    private final Reference2ReferenceMap<Page, PageEntryWidget> pageToWidget = new Reference2ReferenceOpenHashMap();

    public PageListWidget(Dim2i position, VideoSettingsScreen parent) {
        super(position);
        this.parent = parent;
        this.rebuild();
    }

    private void rebuild() {
        int x = this.getX();
        int y = this.getY();
        int width = this.getWidth();
        int height = this.getHeight();
        this.clearChildren();
        this.scrollbar = this.addRenderableChild(new ScrollbarWidget(new Dim2i(this.getLimitX() - 5, y, 5, height), false, false));
        Objects.requireNonNull(this.font);
        int entryHeight = 9 * 2;
        Objects.requireNonNull(this.font);
        int headerHeight = 9 * 3;
        int listHeight = 0;
        for (ModOptions modOptions : ConfigManager.CONFIG.getModOptions()) {
            if (modOptions.pages().isEmpty()) continue;
            ColorTheme theme = modOptions.theme();
            Dim2i headerDim = new Dim2i(x, y + (listHeight += 2), width, headerHeight);
            int modHeaderStart = headerDim.y();
            HeaderEntryWidget header = new HeaderEntryWidget(this, headerDim, modOptions, theme);
            listHeight += headerHeight;
            this.addRenderableChild(header);
            for (Page page : modOptions.pages()) {
                EntryWidget button;
                Dim2i widgetDim = new Dim2i(x, y + listHeight, width, entryHeight);
                if (page instanceof OptionPage) {
                    OptionPage optionPage = (OptionPage)page;
                    int scrollTargetStart = widgetDim.y();
                    if (modHeaderStart != -1) {
                        scrollTargetStart = modHeaderStart;
                        modHeaderStart = -1;
                    }
                    PageEntryWidget pageWidget = new PageEntryWidget(widgetDim, optionPage, theme, scrollTargetStart);
                    button = pageWidget;
                    this.pageToWidget.put((Object)optionPage, (Object)pageWidget);
                } else if (page instanceof ExternalPage) {
                    ExternalPage externalPage = (ExternalPage)page;
                    button = new ExternalPageEntryWidget(widgetDim, externalPage, theme);
                } else {
                    throw new IllegalStateException("Unknown page type: " + String.valueOf(page.getClass()));
                }
                listHeight += entryHeight;
                this.addRenderableChild(button);
            }
        }
        this.scrollbar.setScrollbarContext(listHeight + 5);
    }

    @Override
    public void method_25394(@NonNull class_332 graphics, int mouseX, int mouseY, float delta) {
        PageListWidget.renderBackgroundGradient(graphics, this.getX(), this.getY(), this.getLimitX(), this.getLimitY());
        graphics.method_44379(this.getX(), this.getY(), this.getLimitX(), this.getLimitY());
        super.method_25394(graphics, mouseX, mouseY, delta);
        graphics.method_44380();
    }

    public static void renderBackgroundGradient(class_332 graphics, int x1, int y1, int x2, int y2) {
        graphics.method_25296(x1, y1, x2, y2, 0x40000000, -1879048192);
    }

    private void switchSelectedWidget(EntryWidget widget) {
        if (widget != this.selected) {
            if (this.selected != null) {
                this.selected.setSelected(false);
            }
            this.selected = widget;
            this.selected.setSelected(true);
        }
        int widgetTop = this.selected.getScrollTargetStart();
        int widgetBottom = widgetTop + this.selected.getHeight();
        int viewTop = this.getY() + this.scrollbar.getScrollAmount();
        int viewBottom = viewTop + this.getHeight();
        if (widgetTop < viewTop) {
            this.scrollbar.scrollTo(widgetTop - this.getY());
        } else if (widgetBottom > viewBottom) {
            this.scrollbar.scrollTo(widgetBottom - this.getY() - this.getHeight());
        }
    }

    public void switchSelected(Page page) {
        this.switchSelectedWidget((EntryWidget)this.pageToWidget.get((Object)page));
    }

    private class HeaderEntryWidget
    extends EntryWidget {
        private final class_2960 icon;

        HeaderEntryWidget(PageListWidget pageListWidget, Dim2i dim, ModOptions modOptions, ColorTheme theme) {
            super(dim, (class_2561)class_2561.method_43470((String)modOptions.name()), (class_2561)class_2561.method_43470((String)modOptions.version()), false, theme);
            this.icon = modOptions.icon();
        }

        @Override
        protected int renderIcon(class_332 graphics, int textColor) {
            if (this.icon == null) {
                return super.renderIcon(graphics, textColor);
            }
            return VideoSettingsScreen.renderIconWithSpacing(graphics, this.icon, textColor, this.getX(), this.getY(), this.getHeight(), 4);
        }
    }

    private class PageEntryWidget
    extends EntryWidget {
        private final OptionPage page;
        private final int scrollTargetStart;

        PageEntryWidget(Dim2i dim, OptionPage page, ColorTheme theme, int scrollTargetStart) {
            super(dim, page.name(), true, theme);
            this.page = page;
            this.scrollTargetStart = scrollTargetStart;
        }

        @Override
        public int getScrollTargetStart() {
            return this.scrollTargetStart;
        }

        @Override
        void onAction() {
            PageListWidget.this.switchSelectedWidget(this);
            PageListWidget.this.parent.jumpToPage(this.page);
        }
    }

    private class ExternalPageEntryWidget
    extends EntryWidget {
        private final ExternalPage page;

        ExternalPageEntryWidget(Dim2i dim, ExternalPage page, ColorTheme theme) {
            super(dim, page.name(), true, theme);
            this.page = page;
        }

        @Override
        void onAction() {
            this.page.currentScreenConsumer().accept(PageListWidget.this.parent);
        }
    }

    private class EntryWidget
    extends CenteredFlatWidget {
        EntryWidget(Dim2i dim, class_2561 label, boolean isSelectable, ColorTheme theme) {
            super(dim, label, isSelectable, theme);
        }

        EntryWidget(Dim2i dim, class_2561 label, class_2561 subtitle, boolean isSelectable, ColorTheme theme) {
            super(dim, label, subtitle, isSelectable, theme);
        }

        @Override
        void onAction() {
        }

        public int getScrollTargetStart() {
            return super.getY();
        }

        @Override
        public int getY() {
            return super.getY() - PageListWidget.this.scrollbar.getScrollAmount();
        }
    }
}

