/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.gui.options.control;

import net.caffeinemc.mods.sodium.client.config.structure.EnumOption;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.gui.ColorTheme;
import net.caffeinemc.mods.sodium.client.gui.options.control.AbstractOptionList;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.ControlElement;
import net.caffeinemc.mods.sodium.client.util.Dim2i;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import org.apache.commons.lang3.Validate;

public class CyclingControl<T extends Enum<T>>
implements Control {
    private final EnumOption<T> option;

    public CyclingControl(EnumOption<T> option, Class<T> enumType) {
        Object[] universe = (Enum[])enumType.getEnumConstants();
        Validate.notEmpty((Object[])universe, (String)"The enum universe must contain at least one item", (Object[])new Object[0]);
        this.option = option;
    }

    @Override
    public Option getOption() {
        return this.option;
    }

    @Override
    public ControlElement createElement(class_437 screen, AbstractOptionList list, Dim2i dim, ColorTheme theme) {
        return new CyclingControlElement<T>(list, this.option, dim, theme);
    }

    @Override
    public int getMaxWidth() {
        return 70;
    }

    private static class CyclingControlElement<T extends Enum<T>>
    extends ControlElement {
        private final EnumOption<T> option;
        private final T[] baseValues;

        public CyclingControlElement(AbstractOptionList list, EnumOption<T> option, Dim2i dim, ColorTheme theme) {
            super(list, dim, theme);
            this.option = option;
            this.baseValues = (Enum[])option.enumClass.getEnumConstants();
        }

        @Override
        public Option getOption() {
            return this.option;
        }

        @Override
        public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
            super.method_25394(graphics, mouseX, mouseY, delta);
            Enum value = (Enum)this.option.getValidatedValue();
            class_2561 name = this.option.getElementName(value);
            int strWidth = this.getStringWidth((class_5348)name);
            this.drawString(graphics, name, this.getLimitX() - strWidth - 6, this.getCenterY() + -4, -1);
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            if (this.option.isEnabled() && event.method_74245() == 0 && this.method_25405(event.comp_4798(), event.comp_4799())) {
                this.cycleControl(class_310.method_1551().method_74187());
                return true;
            }
            return false;
        }

        public boolean method_25404(class_11908 event) {
            if (!this.method_25370()) {
                return false;
            }
            if (event.method_74229()) {
                this.cycleControl(class_310.method_1551().method_74187());
                return true;
            }
            return false;
        }

        private void cycleControl(boolean reverse) {
            int startIndex;
            this.playClickSound();
            this.playClickSound();
            Enum currentValue = (Enum)this.option.getValidatedValue();
            for (startIndex = 0; startIndex < this.baseValues.length && this.baseValues[startIndex] != currentValue; ++startIndex) {
            }
            int currentIndex = startIndex;
            while (!this.option.isValueAllowed(currentValue = this.baseValues[currentIndex = reverse ? (currentIndex + this.baseValues.length - 1) % this.baseValues.length : (currentIndex + 1) % this.baseValues.length])) {
            }
            this.option.modifyValue(currentValue);
        }
    }
}

