/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.structure;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.OptionBinding;
import net.caffeinemc.mods.sodium.api.config.option.OptionFlag;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.client.config.structure.Option;
import net.caffeinemc.mods.sodium.client.config.value.DependentValue;
import net.caffeinemc.mods.sodium.client.config.value.DynamicValue;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public abstract class StatefulOption<V>
extends Option {
    final StorageEventHandler storage;
    final Function<V, class_2561> tooltipProvider;
    final OptionImpact impact;
    final EnumSet<OptionFlag> flags;
    final DependentValue<V> defaultValue;
    final OptionBinding<V> binding;
    private final Collection<DynamicValue<?>> dependents = new ObjectOpenHashSet(0);
    private V value;
    private V modifiedValue;

    StatefulOption(class_2960 id, Collection<class_2960> dependencies, class_2561 name, DependentValue<Boolean> enabled, StorageEventHandler storage, Function<V, class_2561> tooltipProvider, OptionImpact impact, EnumSet<OptionFlag> flags, DependentValue<V> defaultValue, OptionBinding<V> binding) {
        super(id, dependencies, name, enabled);
        this.storage = storage;
        this.tooltipProvider = tooltipProvider;
        this.impact = impact;
        this.flags = flags;
        this.defaultValue = defaultValue;
        this.binding = binding;
    }

    @Override
    void visitDependentValues(Consumer<DependentValue<?>> visitor) {
        super.visitDependentValues(visitor);
        visitor.accept(this.defaultValue);
    }

    void registerDependent(DynamicValue<?> dependent) {
        this.dependents.add(dependent);
    }

    public void modifyValue(V value) {
        if (this.modifiedValue != value) {
            this.modifiedValue = value;
            this.state.invalidateDependents(this.dependents);
        }
    }

    @Override
    void loadValueInitial() {
        this.value = this.binding.load();
        this.modifiedValue = this.value;
    }

    @Override
    void resetFromBinding() {
        V defaultValue;
        V previousValue = this.modifiedValue;
        this.value = this.binding.load();
        if (!this.isValueValid(this.value) && (defaultValue = this.defaultValue.get(this.state)) != this.value) {
            this.value = defaultValue;
            this.binding.save(this.value);
            this.state.notifyStorageWrite(this.storage);
        }
        this.modifiedValue = this.value;
        if (this.value != previousValue) {
            this.state.invalidateDependents(this.dependents);
        }
    }

    public V getValidatedValue() {
        if (!this.isValueValid(this.modifiedValue)) {
            V previousValue = this.modifiedValue;
            this.modifiedValue = this.defaultValue.get(this.state);
            if (this.modifiedValue != previousValue) {
                this.state.invalidateDependents(this.dependents);
            }
        }
        return this.modifiedValue;
    }

    @Override
    public boolean hasChanged() {
        return this.modifiedValue != this.value;
    }

    @Override
    boolean applyChanges() {
        if (this.hasChanged()) {
            this.value = this.modifiedValue;
            this.binding.save(this.value);
            this.state.notifyStorageWrite(this.storage);
            return true;
        }
        return false;
    }

    public boolean isValueValid(V value) {
        return true;
    }

    @Override
    public OptionImpact getImpact() {
        return this.impact;
    }

    @Override
    public class_2561 getTooltip() {
        return this.tooltipProvider.apply(this.getValidatedValue());
    }

    @Override
    public EnumSet<OptionFlag> getFlags() {
        return this.flags;
    }

    public StorageEventHandler getStorage() {
        return this.storage;
    }

    public Function<V, class_2561> getTooltipProvider() {
        return this.tooltipProvider;
    }

    public DependentValue<V> getDefaultValue() {
        return this.defaultValue;
    }

    public OptionBinding<V> getBinding() {
        return this.binding;
    }
}

