/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.structure;

import java.util.Collection;
import java.util.EnumSet;
import java.util.function.Consumer;
import java.util.function.Function;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.ControlValueFormatter;
import net.caffeinemc.mods.sodium.api.config.option.OptionBinding;
import net.caffeinemc.mods.sodium.api.config.option.OptionFlag;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.api.config.option.Range;
import net.caffeinemc.mods.sodium.client.config.structure.StatefulOption;
import net.caffeinemc.mods.sodium.client.config.value.DependentValue;
import net.caffeinemc.mods.sodium.client.gui.options.control.Control;
import net.caffeinemc.mods.sodium.client.gui.options.control.SliderControl;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class IntegerOption
extends StatefulOption<Integer> {
    private final DependentValue<Range> range;
    private final ControlValueFormatter valueFormatter;

    public IntegerOption(class_2960 id, Collection<class_2960> dependencies, class_2561 name, DependentValue<Boolean> enabled, StorageEventHandler storage, Function<Integer, class_2561> tooltipProvider, OptionImpact impact, EnumSet<OptionFlag> flags, DependentValue<Integer> defaultValue, OptionBinding<Integer> binding, DependentValue<Range> range, ControlValueFormatter valueFormatter) {
        super(id, dependencies, name, enabled, storage, tooltipProvider, impact, flags, defaultValue, binding);
        this.range = range;
        this.valueFormatter = valueFormatter;
    }

    @Override
    void visitDependentValues(Consumer<DependentValue<?>> visitor) {
        super.visitDependentValues(visitor);
        visitor.accept(this.range);
    }

    @Override
    public boolean isValueValid(Integer value) {
        return this.range.get(this.state).isValueValid(value);
    }

    @Override
    Control createControl() {
        Range range = this.range.get(this.state);
        return new SliderControl(this, range.min(), range.max(), range.step());
    }

    public Range getRange() {
        return this.range.get(this.state);
    }

    public class_2561 formatValue(int value) {
        return this.valueFormatter.format(value);
    }

    public DependentValue<Range> getRangeProvider() {
        return this.range;
    }

    public ControlValueFormatter getValueFormatter() {
        return this.valueFormatter;
    }
}

