/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.world.interests;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_4076;
import net.minecraft.class_4153;
import net.minecraft.class_4156;
import net.minecraft.class_4157;

public interface PoiOrdering {
    default public boolean isOrdered(class_2338 center, class_4153 poiManager, List<class_2338> positions) {
        if (!positions.isEmpty()) {
            class_2338 curr = positions.getFirst();
            for (int i = 1; i < positions.size(); ++i) {
                class_2338 next = positions.get(i);
                int order = this.compare(center, poiManager, curr, next);
                if (order != 1) {
                    return false;
                }
                curr = next;
            }
        }
        return true;
    }

    default public void checkOrderOrThrow(class_2338 center, class_4153 poiManager, List<class_2338> positions) {
        if (!positions.isEmpty()) {
            class_2338 curr = positions.getFirst();
            for (int i = 1; i < positions.size(); ++i) {
                class_2338 next = positions.get(i);
                int order = this.compare(center, poiManager, curr, next);
                if (order != -1) {
                    if (order == 0) {
                        order = this.compare(center, poiManager, curr, next);
                        throw new IllegalStateException("Positions are equal at index " + i + ": " + String.valueOf(curr) + " == " + String.valueOf(next));
                    }
                    order = this.compare(center, poiManager, curr, next);
                    throw new IllegalStateException("Positions are ordered incorrectly at index " + i + ": " + String.valueOf(curr) + " < " + String.valueOf(next) + "! Offsets: curr=(" + (curr.method_10263() - center.method_10263()) + ", " + (curr.method_10264() - center.method_10264()) + ", " + (curr.method_10260() - center.method_10260()) + "), next=(" + (next.method_10263() - center.method_10263()) + ", " + (next.method_10264() - center.method_10264()) + ", " + (next.method_10260() - center.method_10260()) + ")");
                }
                curr = next;
            }
        }
    }

    default public Comparator<class_2338> getAsComparator(class_2338 center, class_4153 poiManager) {
        return (posA, posB) -> this.compare(center, poiManager, (class_2338)posA, (class_2338)posB);
    }

    public int compare(class_2338 var1, class_4153 var2, class_2338 var3, class_2338 var4);

    public record L2ThenMinYThenInSquare() implements PoiOrdering
    {
        public static final L2ThenMinYThenInSquare INSTANCE = new L2ThenMinYThenInSquare();

        @Override
        public int compare(class_2338 center, class_4153 poiManager, class_2338 posA, class_2338 posB) {
            double distBSq;
            double distASq = center.method_10262((class_2382)posA);
            int orderDist = Double.compare(distASq, distBSq = center.method_10262((class_2382)posB));
            if (orderDist != 0) {
                return orderDist;
            }
            int orderY = Integer.compare(posA.method_10264(), posB.method_10264());
            if (orderY != 0) {
                return orderY;
            }
            return InSquare.INSTANCE.compare(center, poiManager, posA, posB);
        }
    }

    public record L2ThenInSquare() implements PoiOrdering
    {
        public static final L2ThenInSquare INSTANCE = new L2ThenInSquare();

        @Override
        public int compare(class_2338 center, class_4153 poiManager, class_2338 posA, class_2338 posB) {
            double distBSq;
            double distASq = center.method_10262((class_2382)posA);
            int orderDist = Double.compare(distASq, distBSq = center.method_10262((class_2382)posB));
            if (orderDist != 0) {
                return orderDist;
            }
            return InSquare.INSTANCE.compare(center, poiManager, posA, posB);
        }
    }

    public record InSquare() implements PoiOrdering
    {
        public static final InSquare INSTANCE = new InSquare();

        @Override
        public int compare(class_2338 center, class_4153 poiManager, class_2338 posA, class_2338 posB) {
            int bChunkX;
            int bChunkZ;
            int aChunkZ = posA.method_10260() >> 4;
            int orderZ = Integer.compare(aChunkZ, bChunkZ = posB.method_10260() >> 4);
            if (orderZ != 0) {
                return orderZ;
            }
            int aChunkX = posA.method_10263() >> 4;
            int orderX = Integer.compare(aChunkX, bChunkX = posB.method_10263() >> 4);
            if (orderX != 0) {
                return orderX;
            }
            return InChunk.INSTANCE.compare(center, poiManager, posA, posB);
        }
    }

    public record InChunk() implements PoiOrdering
    {
        public static final InChunk INSTANCE = new InChunk();

        @Override
        public int compare(class_2338 center, class_4153 poiManager, class_2338 posA, class_2338 posB) {
            int bChunkY;
            int bChunkX;
            int bChunkZ;
            if (posA.equals((Object)posB)) {
                return 0;
            }
            int aChunkZ = posA.method_10260() >> 4;
            int orderZ = Integer.compare(aChunkZ, bChunkZ = posB.method_10260() >> 4);
            if (orderZ != 0) {
                throw new IllegalStateException("Positions are not in the same chunk: " + String.valueOf(posA) + " in " + String.valueOf(new class_1923(posA)) + " vs " + String.valueOf(posB) + " in " + String.valueOf(new class_1923(posB)));
            }
            int aChunkX = posA.method_10263() >> 4;
            int orderX = Integer.compare(aChunkX, bChunkX = posB.method_10263() >> 4);
            if (orderX != 0) {
                throw new IllegalStateException("Positions are not in the same chunk: " + String.valueOf(posA) + " in " + String.valueOf(new class_1923(posA)) + " vs " + String.valueOf(posB) + " in " + String.valueOf(new class_1923(posB)));
            }
            int aChunkY = posA.method_10264() >> 4;
            int orderY = Integer.compare(aChunkY, bChunkY = posB.method_10264() >> 4);
            if (orderY != 0) {
                return orderY;
            }
            Optional poiSection = poiManager.method_19294(class_4076.method_33706((class_2338)posA));
            if (poiSection.isEmpty()) {
                throw new IllegalStateException("PoiManager " + String.valueOf(poiManager) + " has no section at position " + String.valueOf(posA));
            }
            class_4157 poiSection1 = (class_4157)poiSection.get();
            List<class_4156> retrievedRecords = poiSection1.method_19150(a -> true, class_4153.class_4155.field_18489).filter(poiRecord -> poiRecord.method_19141().equals((Object)posA) || poiRecord.method_19141().equals((Object)posB)).toList();
            if (retrievedRecords.size() != 2) {
                throw new IllegalStateException("Expected two POI records at " + String.valueOf(posA) + ", " + String.valueOf(posB) + ", found " + retrievedRecords.size());
            }
            if (retrievedRecords.getFirst().method_19141().equals((Object)posA)) {
                return -1;
            }
            if (retrievedRecords.getFirst().method_19141().equals((Object)posB)) {
                return 1;
            }
            throw new IllegalStateException("Expected two differing poi positions matching " + String.valueOf(posA) + ", " + String.valueOf(posB) + ", found " + String.valueOf(retrievedRecords));
        }
    }
}

