/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.render;

import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.event.RenderEventHandler;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.mixin.item.IMixinContainerComponent;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.InventoryOverlayContext;
import fi.dy.masa.malilib.render.InventoryOverlayType;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.MathUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.malilib.util.data.DataBlockUtils;
import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.data.tag.ListData;
import fi.dy.masa.malilib.util.game.IEntityOwnedInventory;
import fi.dy.masa.malilib.util.log.AnsiLogger;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10256;
import net.minecraft.class_10799;
import net.minecraft.class_11573;
import net.minecraft.class_11586;
import net.minecraft.class_11597;
import net.minecraft.class_12137;
import net.minecraft.class_1258;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1661;
import net.minecraft.class_1694;
import net.minecraft.class_1700;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2260;
import net.minecraft.class_2281;
import net.minecraft.class_2315;
import net.minecraft.class_2336;
import net.minecraft.class_2363;
import net.minecraft.class_2371;
import net.minecraft.class_2377;
import net.minecraft.class_2387;
import net.minecraft.class_2480;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2589;
import net.minecraft.class_2591;
import net.minecraft.class_2601;
import net.minecraft.class_2609;
import net.minecraft.class_2614;
import net.minecraft.class_2627;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3708;
import net.minecraft.class_3715;
import net.minecraft.class_4836;
import net.minecraft.class_5455;
import net.minecraft.class_5537;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_7714;
import net.minecraft.class_7716;
import net.minecraft.class_8001;
import net.minecraft.class_8168;
import net.minecraft.class_8886;
import net.minecraft.class_8887;
import net.minecraft.class_9288;
import net.minecraft.class_9334;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class InventoryOverlay {
    private static final AnsiLogger LOGGER = new AnsiLogger(InventoryOverlay.class);
    public static final class_2960 TEXTURE_BREWING_STAND = class_2960.method_60656((String)"textures/gui/container/brewing_stand.png");
    public static final class_2960 TEXTURE_CRAFTER = class_2960.method_60656((String)"textures/gui/container/crafter.png");
    public static final class_2960 TEXTURE_DISPENSER = class_2960.method_60656((String)"textures/gui/container/dispenser.png");
    public static final class_2960 TEXTURE_DOUBLE_CHEST = class_2960.method_60656((String)"textures/gui/container/generic_54.png");
    public static final class_2960 TEXTURE_FURNACE = class_2960.method_60656((String)"textures/gui/container/furnace.png");
    public static final class_2960 TEXTURE_HOPPER = class_2960.method_60656((String)"textures/gui/container/hopper.png");
    public static final class_2960 TEXTURE_PLAYER_INV = class_2960.method_60656((String)"textures/gui/container/inventory.png");
    public static final class_2960 TEXTURE_SINGLE_CHEST = class_2960.method_60656((String)"textures/gui/container/shulker_box.png");
    public static final class_2960 TEXTURE_EMPTY_SHIELD = class_2960.method_60656((String)"container/slot/shield");
    public static final class_2960 TEXTURE_LOCKED_SLOT = class_2960.method_60656((String)"container/crafter/disabled_slot");
    public static final class_2960 TEXTURE_EMPTY_HORSE_ARMOR = class_2960.method_60656((String)"container/slot/horse_armor");
    public static final class_2960 TEXTURE_EMPTY_LLAMA_ARMOR = class_2960.method_60656((String)"container/slot/llama_armor");
    public static final class_2960 TEXTURE_EMPTY_SADDLE = class_2960.method_60656((String)"container/slot/saddle");
    public static final class_2960 TEXTURE_EMPTY_BREWER_FUEL = class_2960.method_60656((String)"container/slot/brewing_fuel");
    public static final class_2960 TEXTURE_EMPTY_POTION = class_2960.method_60656((String)"container/slot/potion");
    public static final class_2960 TEXTURE_EMPTY_SLOT_AMETHYST = class_2960.method_60656((String)"container/slot/amethyst_shard");
    public static final class_2960 TEXTURE_EMPTY_SLOT_AXE = class_2960.method_60656((String)"container/slot/axe");
    public static final class_2960 TEXTURE_EMPTY_SLOT_BANNER = class_2960.method_60656((String)"container/slot/banner");
    public static final class_2960 TEXTURE_EMPTY_SLOT_PATTERN = class_2960.method_60656((String)"container/slot/banner_pattern");
    public static final class_2960 TEXTURE_EMPTY_SLOT_DIAMOND = class_2960.method_60656((String)"container/slot/diamond");
    public static final class_2960 TEXTURE_EMPTY_SLOT_DYE = class_2960.method_60656((String)"container/slot/dye");
    public static final class_2960 TEXTURE_EMPTY_SLOT_EMERALD = class_2960.method_60656((String)"container/slot/emerald");
    public static final class_2960 TEXTURE_EMPTY_SLOT_HOE = class_2960.method_60656((String)"container/slot/hoe");
    public static final class_2960 TEXTURE_EMPTY_SLOT_INGOT = class_2960.method_60656((String)"container/slot/ingot");
    public static final class_2960 TEXTURE_EMPTY_SLOT_LAPIS = class_2960.method_60656((String)"container/slot/lapis_lazuli");
    public static final class_2960 TEXTURE_EMPTY_SLOT_PICKAXE = class_2960.method_60656((String)"container/slot/pickaxe");
    public static final class_2960 TEXTURE_EMPTY_SLOT_QUARTZ = class_2960.method_60656((String)"container/slot/quartz");
    public static final class_2960 TEXTURE_EMPTY_SLOT_REDSTONE = class_2960.method_60656((String)"container/slot/redstone_dust");
    public static final class_2960 TEXTURE_EMPTY_SLOT_SHOVEL = class_2960.method_60656((String)"container/slot/shovel");
    public static final class_2960 TEXTURE_EMPTY_SLOT_ARMOR_TRIM = class_2960.method_60656((String)"container/slot/smithing_template_armor_trim");
    public static final class_2960 TEXTURE_EMPTY_SLOT_UPGRADE = class_2960.method_60656((String)"container/slot/smithing_template_netherite_upgrade");
    public static final class_2960 TEXTURE_EMPTY_SLOT_SWORD = class_2960.method_60656((String)"container/slot/sword");
    public static final class_2960 TEXTURE_EMPTY_SLOT = class_2960.method_60656((String)"container/slot");
    public static final class_2960 TEXTURE_HIGHLIGHT_BACK = class_2960.method_60656((String)"container/slot_highlight_back");
    public static final class_2960 TEXTURE_HIGHLIGHT_FRONT = class_2960.method_60656((String)"container/slot_highlight_front");
    private static final class_1304[] VALID_EQUIPMENT_SLOTS = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166};
    public static final InventoryProperties INV_PROPS_TEMP = new InventoryProperties();
    private static final class_2960[] EMPTY_SLOT_TEXTURES = new class_2960[]{class_2960.method_60656((String)"container/slot/boots"), class_2960.method_60656((String)"container/slot/leggings"), class_2960.method_60656((String)"container/slot/chestplate"), class_2960.method_60656((String)"container/slot/helmet")};
    private static class_1799 hoveredStack = null;

    public static void renderInventoryBackground(GuiContext ctx, InventoryOverlayType type, int x, int y, int slotsPerRow, int totalSlots) {
        InventoryOverlay.renderInventoryBackground(ctx, type, x, y, slotsPerRow, totalSlots, -1);
    }

    public static void renderInventoryBackground(GuiContext ctx, InventoryOverlayType type, int x, int y, int slotsPerRow, int totalSlots, int color) {
        if (type == InventoryOverlayType.FURNACE) {
            Pair<GpuTextureView, class_12137> pair = ctx.bindTexture(TEXTURE_FURNACE);
            if (pair == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y, 0, 0, 4, 64, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 4, y, 84, 0, 92, 4, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y + 64, 0, 162, 92, 4, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 92, y + 4, 172, 102, 4, 64, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 4, y + 4, 52, 13, 88, 60, color);
        } else if (type == InventoryOverlayType.BREWING_STAND) {
            Pair<GpuTextureView, class_12137> pair = ctx.bindTexture(TEXTURE_BREWING_STAND);
            if (pair == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y, 0, 0, 4, 68, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 4, y, 63, 0, 113, 4, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y + 68, 0, 162, 113, 4, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 113, y + 4, 172, 98, 4, 68, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 4, y + 4, 13, 13, 109, 64, color);
        } else if (type == InventoryOverlayType.CRAFTER) {
            Pair<GpuTextureView, class_12137> pair = ctx.bindTexture(TEXTURE_DISPENSER);
            if (pair == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y, 0, 0, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y, 115, 0, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y + 61, 0, 159, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 61, y + 7, 169, 105, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y + 7, 61, 16, 54, 54, color);
        } else if (type == InventoryOverlayType.DISPENSER) {
            Pair<GpuTextureView, class_12137> pair = ctx.bindTexture(TEXTURE_DISPENSER);
            if (pair == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y, 0, 0, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y, 115, 0, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y + 61, 0, 159, 61, 7, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 61, y + 7, 169, 105, 7, 61, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y + 7, 61, 16, 54, 54, color);
        } else if (type == InventoryOverlayType.HOPPER) {
            Pair<GpuTextureView, class_12137> pair = ctx.bindTexture(TEXTURE_HOPPER);
            if (pair == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y, 0, 0, 7, 25, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y, 79, 0, 97, 7, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y + 25, 0, 126, 97, 7, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 97, y + 7, 169, 108, 7, 25, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y + 7, 43, 19, 90, 18, color);
        } else if (type == InventoryOverlayType.VILLAGER) {
            Pair<GpuTextureView, class_12137> pair = ctx.bindTexture(TEXTURE_DOUBLE_CHEST);
            if (pair == null) {
                return;
            }
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y, 0, 0, 7, 79, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y, 133, 0, 43, 7, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y + 79, 0, 215, 43, 7, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 43, y + 7, 169, 143, 7, 79, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y + 7, 7, 17, 36, 72, color);
        } else if (type == InventoryOverlayType.FIXED_27) {
            InventoryOverlay.renderInventoryBackground27(ctx, x, y, color);
        } else if (type == InventoryOverlayType.FIXED_54) {
            InventoryOverlay.renderInventoryBackground54(ctx, x, y, color);
        } else {
            Pair<GpuTextureView, class_12137> pair = ctx.bindTexture(TEXTURE_DOUBLE_CHEST);
            if (pair == null) {
                return;
            }
            int rows = (int)Math.ceil((double)totalSlots / (double)slotsPerRow);
            int bgw = Math.min(totalSlots, slotsPerRow) * 18 + 7;
            int bgh = rows * 18 + 7;
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y, 0, 0, 7, bgh, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y, 176 - bgw, 0, bgw, 7, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x, y + bgh, 0, 215, bgw, 7, color);
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + bgw, y + 7, 169, 222 - bgh, 7, bgh, color);
            for (int row = 0; row < rows; ++row) {
                int rowLen = class_3532.method_15340((int)(totalSlots - row * slotsPerRow), (int)1, (int)slotsPerRow);
                RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y + row * 18 + 7, 7, 17, rowLen * 18, 18, color);
                if (rows <= 1 || rowLen >= slotsPerRow) continue;
                RenderUtils.drawTexturedRectBatched(ctx, pair, x + rowLen * 18 + 7, y + row * 18 + 7, 7, 3, (slotsPerRow - rowLen) * 18, 9, color);
                RenderUtils.drawTexturedRectBatched(ctx, pair, x + rowLen * 18 + 7, y + row * 18 + 16, 7, 3, (slotsPerRow - rowLen) * 18, 9, color);
            }
        }
    }

    public static void renderInventoryBackground27(GuiContext ctx, int x, int y, int color) {
        Pair<GpuTextureView, class_12137> pair = ctx.bindTexture(TEXTURE_SINGLE_CHEST);
        if (pair == null) {
            return;
        }
        RenderUtils.drawTexturedRectBatched(ctx, pair, x, y, 0, 0, 7, 61, color);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y, 7, 0, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x, y + 61, 0, 159, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x + 169, y + 7, 169, 105, 7, 61, color);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y + 7, 7, 17, 162, 54, color);
    }

    public static void renderInventoryBackground54(GuiContext ctx, int x, int y, int color) {
        Pair<GpuTextureView, class_12137> pair = ctx.bindTexture(TEXTURE_DOUBLE_CHEST);
        if (pair == null) {
            return;
        }
        RenderUtils.drawTexturedRectBatched(ctx, pair, x, y, 0, 0, 7, 115, color);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y, 7, 0, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x, y + 115, 0, 215, 169, 7, color);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x + 169, y + 7, 169, 107, 7, 115, color);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x + 7, y + 7, 7, 17, 162, 108, color);
    }

    public static void renderInventoryBackgroundSlots(GuiContext ctx, InventoryOverlayType type, class_1263 inv, int x, int y) {
        if (type == InventoryOverlayType.BREWING_STAND) {
            InventoryOverlay.renderBrewerBackgroundSlots(ctx, inv, x, y);
        } else if (type == InventoryOverlayType.HORSE) {
            InventoryOverlay.renderHorseArmorBackgroundSlots(ctx, inv, x, y);
        } else if (type == InventoryOverlayType.LLAMA) {
            InventoryOverlay.renderLlamaArmorBackgroundSlots(ctx, inv, x, y);
        } else if (type == InventoryOverlayType.WOLF || type == InventoryOverlayType.HAPPY_GHAST || type == InventoryOverlayType.COPPER_GOLEM) {
            InventoryOverlay.renderWolfArmorBackgroundSlots(ctx, inv, x, y);
        }
    }

    public static void renderBrewerBackgroundSlots(GuiContext ctx, class_1263 inv, int x, int y) {
        InventoryOverlay.renderBrewerBackgroundSlots(ctx, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderBrewerBackgroundSlots(GuiContext ctx, class_1263 inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.method_5438(0).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(ctx, TEXTURE_EMPTY_POTION, x + 47, y + 42, scale, mouseX, mouseY);
        }
        if (inv.method_5438(1).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(ctx, TEXTURE_EMPTY_POTION, x + 70, y + 49, scale, mouseX, mouseY);
        }
        if (inv.method_5438(2).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(ctx, TEXTURE_EMPTY_POTION, x + 93, y + 42, scale, mouseX, mouseY);
        }
        if (inv.method_5438(4).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(ctx, TEXTURE_EMPTY_BREWER_FUEL, x + 8, y + 8, scale, mouseX, mouseY);
        }
    }

    public static void renderHorseArmorBackgroundSlots(GuiContext ctx, class_1263 inv, int x, int y) {
        InventoryOverlay.renderHorseArmorBackgroundSlots(ctx, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderHorseArmorBackgroundSlots(GuiContext ctx, class_1263 inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.method_5438(0).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(ctx, TEXTURE_EMPTY_HORSE_ARMOR, x, y, scale, mouseX, mouseY);
        }
        if (inv.method_5438(1).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(ctx, TEXTURE_EMPTY_SADDLE, x, y + 18, scale, mouseX, mouseY);
        }
    }

    public static void renderLlamaArmorBackgroundSlots(GuiContext ctx, class_1263 inv, int x, int y) {
        InventoryOverlay.renderLlamaArmorBackgroundSlots(ctx, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderLlamaArmorBackgroundSlots(GuiContext ctx, class_1263 inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.method_5438(0).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(ctx, TEXTURE_EMPTY_LLAMA_ARMOR, x, y, scale, mouseX, mouseY);
        }
    }

    public static void renderWolfArmorBackgroundSlots(GuiContext ctx, class_1263 inv, int x, int y) {
        InventoryOverlay.renderWolfArmorBackgroundSlots(ctx, inv, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderWolfArmorBackgroundSlots(GuiContext ctx, class_1263 inv, int x, int y, float scale, double mouseX, double mouseY) {
        if (inv.method_5438(0).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(ctx, TEXTURE_EMPTY_HORSE_ARMOR, x, y, scale, mouseX, mouseY);
        }
    }

    public static void renderEquipmentOverlayBackground(GuiContext ctx, int x, int y, class_1309 entity) {
        Pair<GpuTextureView, class_12137> pair = ctx.bindTexture(TEXTURE_DISPENSER);
        if (pair == null) {
            return;
        }
        RenderUtils.drawTexturedRectBatched(ctx, pair, x, y, 0, 0, 50, 83);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x + 50, y, 173, 0, 3, 83);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x, y + 83, 0, 163, 50, 3);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x + 50, y + 83, 173, 163, 3, 3);
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            RenderUtils.drawTexturedRectBatched(ctx, pair, x + xOff, y + yOff, 61, 16, 18, 18);
            ++i;
            yOff += 18;
        }
        RenderUtils.drawTexturedRectBatched(ctx, pair, x + 28, y + 36 + 7, 61, 16, 18, 18);
        RenderUtils.drawTexturedRectBatched(ctx, pair, x + 28, y + 54 + 7, 61, 16, 18, 18);
        if (entity.method_6118(class_1304.field_6171).method_7960()) {
            InventoryOverlay.renderBackgroundSlotAt(ctx, TEXTURE_EMPTY_SHIELD, x + 28 + 1, y + 54 + 7 + 1);
        }
        i = 0;
        xOff = 7;
        yOff = 7;
        while (i < 4) {
            class_1304 eqSlot = VALID_EQUIPMENT_SLOTS[i];
            if (entity.method_6118(eqSlot).method_7960()) {
                class_2960 texture = EMPTY_SLOT_TEXTURES[eqSlot.method_5927()];
                InventoryOverlay.renderBackgroundSlotAt(ctx, texture, x + xOff + 1, y + yOff + 1);
            }
            ++i;
            yOff += 18;
        }
    }

    public static InventoryOverlayType getInventoryType(@Nullable class_1263 inv) {
        class_1263 class_12632 = inv;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_2627.class, class_1258.class, class_10256.class, class_1694.class, class_2609.class, class_2589.class, class_8887.class, class_2601.class, class_2614.class, class_1700.class, class_7716.class, class_11597.class, class_1661.class, IEntityOwnedInventory.class}, (Object)class_12632, n)) {
            case -1: {
                return InventoryOverlayType.GENERIC;
            }
            case 0: {
                class_2627 itemStacks = (class_2627)class_12632;
                return InventoryOverlayType.FIXED_27;
            }
            case 1: {
                class_1258 itemStacks = (class_1258)class_12632;
                return InventoryOverlayType.FIXED_54;
            }
            case 2: {
                class_10256 itemStacks = (class_10256)class_12632;
                return InventoryOverlayType.FIXED_27;
            }
            case 3: {
                class_1694 itemStacks = (class_1694)class_12632;
                return InventoryOverlayType.FIXED_27;
            }
            case 4: {
                class_2609 itemStacks = (class_2609)class_12632;
                return InventoryOverlayType.FURNACE;
            }
            case 5: {
                class_2589 itemStacks = (class_2589)class_12632;
                return InventoryOverlayType.BREWING_STAND;
            }
            case 6: {
                class_8887 itemStacks = (class_8887)class_12632;
                return InventoryOverlayType.CRAFTER;
            }
            case 7: {
                class_2601 itemStacks = (class_2601)class_12632;
                return InventoryOverlayType.DISPENSER;
            }
            case 8: {
                class_2614 itemStacks = (class_2614)class_12632;
                return InventoryOverlayType.HOPPER;
            }
            case 9: {
                class_1700 itemStacks = (class_1700)class_12632;
                return InventoryOverlayType.HOPPER;
            }
            case 10: {
                class_7716 itemStacks = (class_7716)class_12632;
                return InventoryOverlayType.BOOKSHELF;
            }
            case 11: {
                class_11597 itemStacks = (class_11597)class_12632;
                return InventoryOverlayType.WALL_SHELF;
            }
            case 12: {
                class_1661 itemStacks = (class_1661)class_12632;
                return InventoryOverlayType.PLAYER;
            }
            case 13: {
                IEntityOwnedInventory inventory = (IEntityOwnedInventory)class_12632;
                if (inventory.malilib$getEntityOwner() instanceof class_1501) {
                    return InventoryOverlayType.LLAMA;
                }
                if (inventory.malilib$getEntityOwner() instanceof class_1493) {
                    return InventoryOverlayType.WOLF;
                }
                if (inventory.malilib$getEntityOwner() instanceof class_11573) {
                    return InventoryOverlayType.COPPER_GOLEM;
                }
                if (inventory.malilib$getEntityOwner() instanceof class_1496) {
                    return InventoryOverlayType.HORSE;
                }
                if (!(inventory.malilib$getEntityOwner() instanceof class_4836)) break;
                return InventoryOverlayType.VILLAGER;
            }
        }
        return InventoryOverlayType.GENERIC;
    }

    public static InventoryOverlayType getInventoryType(class_1799 stack) {
        class_1792 item = stack.method_7909();
        class_9288 container = (class_9288)stack.method_58695(class_9334.field_49622, (Object)class_9288.field_49334);
        if (item instanceof class_1747) {
            class_2248 block = ((class_1747)item).method_7711();
            if (block instanceof class_2480 || block instanceof class_2281 || block instanceof class_3708) {
                int size = ((IMixinContainerComponent)container).malilib_getStacks().size();
                if (size >= 0 && size <= 27) {
                    return InventoryOverlayType.FIXED_27;
                }
                if (size > 27 && size <= 54) {
                    return InventoryOverlayType.FIXED_54;
                }
                if (size > 54 && size < 256) {
                    return InventoryOverlayType.GENERIC;
                }
            } else {
                if (block instanceof class_2363) {
                    return InventoryOverlayType.FURNACE;
                }
                if (block instanceof class_2315) {
                    return InventoryOverlayType.DISPENSER;
                }
                if (block instanceof class_2377) {
                    return InventoryOverlayType.HOPPER;
                }
                if (block instanceof class_2260) {
                    return InventoryOverlayType.BREWING_STAND;
                }
                if (block instanceof class_8886) {
                    return InventoryOverlayType.CRAFTER;
                }
                if (block instanceof class_8168 || block instanceof class_2387 || block instanceof class_3715) {
                    return InventoryOverlayType.SINGLE_ITEM;
                }
                if (block instanceof class_7714) {
                    return InventoryOverlayType.BOOKSHELF;
                }
                if (block instanceof class_11586) {
                    return InventoryOverlayType.WALL_SHELF;
                }
                if (block instanceof class_2336) {
                    return InventoryOverlayType.ENDER_CHEST;
                }
            }
        } else if (item instanceof class_5537) {
            return InventoryOverlayType.BUNDLE;
        }
        return InventoryOverlayType.GENERIC;
    }

    public static InventoryOverlayType getInventoryType(@Nonnull CompoundData data) {
        class_1299<?> entityType;
        class_2591<?> blockType = DataBlockUtils.getBlockEntityType(data);
        if (blockType != null) {
            if (blockType.equals((Object)class_2591.field_11896) || blockType.equals((Object)class_2591.field_16411) || blockType.equals((Object)class_2591.field_11914) || blockType.equals((Object)class_2591.field_11891)) {
                ListData list;
                if (data.contains("Items", 9) && (list = data.getList("Items")).size() > 27) {
                    return InventoryOverlayType.FIXED_54;
                }
                return InventoryOverlayType.FIXED_27;
            }
            if (blockType.equals((Object)class_2591.field_11903) || blockType.equals((Object)class_2591.field_16415) || blockType.equals((Object)class_2591.field_16414)) {
                return InventoryOverlayType.FURNACE;
            }
            if (blockType.equals((Object)class_2591.field_11887) || blockType.equals((Object)class_2591.field_11899)) {
                return InventoryOverlayType.DISPENSER;
            }
            if (blockType.equals((Object)class_2591.field_11888)) {
                return InventoryOverlayType.HOPPER;
            }
            if (blockType.equals((Object)class_2591.field_11894)) {
                return InventoryOverlayType.BREWING_STAND;
            }
            if (blockType.equals((Object)class_2591.field_46808)) {
                return InventoryOverlayType.CRAFTER;
            }
            if (blockType.equals((Object)class_2591.field_42781) || blockType.equals((Object)class_2591.field_11907) || blockType.equals((Object)class_2591.field_16412)) {
                return InventoryOverlayType.SINGLE_ITEM;
            }
            if (blockType.equals((Object)class_2591.field_40329)) {
                return InventoryOverlayType.BOOKSHELF;
            }
            if (blockType.equals((Object)class_2591.field_61437)) {
                return InventoryOverlayType.WALL_SHELF;
            }
            if (blockType.equals((Object)class_2591.field_11901)) {
                return InventoryOverlayType.ENDER_CHEST;
            }
        }
        if ((entityType = DataEntityUtils.getEntityType(data)) != null) {
            if (entityType.equals((Object)class_1299.field_6126) || entityType.equals((Object)class_1299.field_54415) || entityType.equals((Object)class_1299.field_54418) || entityType.equals((Object)class_1299.field_54421) || entityType.equals((Object)class_1299.field_54423) || entityType.equals((Object)class_1299.field_54407) || entityType.equals((Object)class_1299.field_54413) || entityType.equals((Object)class_1299.field_54409) || entityType.equals((Object)class_1299.field_54411) || entityType.equals((Object)class_1299.field_54563) || entityType.equals((Object)class_1299.field_54417)) {
                return InventoryOverlayType.FIXED_27;
            }
            if (entityType.equals((Object)class_1299.field_6058)) {
                return InventoryOverlayType.HOPPER;
            }
            if (entityType.equals((Object)class_1299.field_6139) || entityType.equals((Object)class_1299.field_6067) || entityType.equals((Object)class_1299.field_6057) || entityType.equals((Object)class_1299.field_40116) || entityType.equals((Object)class_1299.field_6075) || entityType.equals((Object)class_1299.field_6048)) {
                return InventoryOverlayType.HORSE;
            }
            if (entityType.equals((Object)class_1299.field_6074) || entityType.equals((Object)class_1299.field_17714)) {
                return InventoryOverlayType.LLAMA;
            }
            if (entityType.equals((Object)class_1299.field_6055)) {
                return InventoryOverlayType.WOLF;
            }
            if (entityType.equals((Object)class_1299.field_59668)) {
                return InventoryOverlayType.HAPPY_GHAST;
            }
            if (entityType.equals((Object)class_1299.field_61221)) {
                return InventoryOverlayType.COPPER_GOLEM;
            }
            if (entityType.equals((Object)class_1299.field_6077) || entityType.equals((Object)class_1299.field_38384) || entityType.equals((Object)class_1299.field_6105) || entityType.equals((Object)class_1299.field_22281) || entityType.equals((Object)class_1299.field_17713) || entityType.equals((Object)class_1299.field_6054)) {
                return InventoryOverlayType.VILLAGER;
            }
            if (entityType.equals((Object)class_1299.field_6097)) {
                return InventoryOverlayType.PLAYER;
            }
            if (entityType.equals((Object)class_1299.field_6131)) {
                return InventoryOverlayType.ARMOR_STAND;
            }
            if (data.containsLenient("attributes") || data.containsLenient("active_effects") || data.containsLenient("FallFlying")) {
                return InventoryOverlayType.LIVING_ENTITY;
            }
        }
        return InventoryOverlayType.GENERIC;
    }

    public static InventoryOverlayType getBestInventoryType(@Nonnull class_1263 inv, @Nonnull CompoundData data) {
        InventoryOverlayType n;
        InventoryOverlayType i = InventoryOverlay.getInventoryType(inv);
        if (i != (n = InventoryOverlay.getInventoryType(data)) && i == InventoryOverlayType.GENERIC) {
            return n;
        }
        return i;
    }

    public static InventoryOverlayType getBestInventoryType(InventoryOverlayContext ctx, @Nullable class_1263 inv, @Nonnull CompoundData data) {
        InventoryOverlayType n;
        InventoryOverlayType i = InventoryOverlay.getInventoryType(inv);
        if (i != (n = InventoryOverlay.getInventoryType(data)) && i == InventoryOverlayType.GENERIC) {
            if (n != ctx.type() && ctx.type() != InventoryOverlayType.GENERIC) {
                return ctx.type();
            }
            return n;
        }
        return i;
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryOverlayType type, int totalSlots) {
        return InventoryOverlay.getInventoryPropsTemp(type, totalSlots, 9);
    }

    public static InventoryProperties getInventoryPropsTemp(InventoryOverlayType type, int totalSlots, int slotsPerARow) {
        InventoryOverlay.INV_PROPS_TEMP.totalSlots = totalSlots;
        if (type == InventoryOverlayType.FURNACE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 96;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryOverlayType.BREWING_STAND) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 0;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 0;
            InventoryOverlay.INV_PROPS_TEMP.width = 109;
            InventoryOverlay.INV_PROPS_TEMP.height = 72;
        } else if (type == InventoryOverlayType.CRAFTER || type == InventoryOverlayType.DISPENSER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryOverlayType.HORSE || type == InventoryOverlayType.LLAMA || type == InventoryOverlayType.WOLF || type == InventoryOverlayType.COPPER_GOLEM) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = Math.max(1, totalSlots / 3);
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = totalSlots * 18 / 3 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = 68;
        } else if (type == InventoryOverlayType.HOPPER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 5;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 105;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryOverlayType.VILLAGER) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 2;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 50;
            InventoryOverlay.INV_PROPS_TEMP.height = 86;
        } else if (type == InventoryOverlayType.SINGLE_ITEM) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 1;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 32;
            InventoryOverlay.INV_PROPS_TEMP.height = 32;
        } else if (type == InventoryOverlayType.BOOKSHELF) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 50;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = 6;
        } else if (type == InventoryOverlayType.WALL_SHELF) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 3;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            InventoryOverlay.INV_PROPS_TEMP.width = 68;
            InventoryOverlay.INV_PROPS_TEMP.height = 50;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = 3;
        } else if (type == InventoryOverlayType.BUNDLE) {
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = slotsPerARow != 9 ? MathUtils.clamp(slotsPerARow, 6, 9) : 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.totalSlots = rows * InventoryOverlay.INV_PROPS_TEMP.slotsPerRow;
        } else {
            if (type == InventoryOverlayType.FIXED_27 || type == InventoryOverlayType.PLAYER || type == InventoryOverlayType.ENDER_CHEST) {
                totalSlots = 27;
            } else if (type == InventoryOverlayType.FIXED_54) {
                totalSlots = 54;
            }
            InventoryOverlay.INV_PROPS_TEMP.slotsPerRow = 9;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetX = 8;
            InventoryOverlay.INV_PROPS_TEMP.slotOffsetY = 8;
            int rows = (int)Math.ceil((double)totalSlots / (double)InventoryOverlay.INV_PROPS_TEMP.slotsPerRow);
            InventoryOverlay.INV_PROPS_TEMP.width = Math.min(InventoryOverlay.INV_PROPS_TEMP.slotsPerRow, totalSlots) * 18 + 14;
            InventoryOverlay.INV_PROPS_TEMP.height = rows * 18 + 14;
        }
        return INV_PROPS_TEMP;
    }

    public static void renderInventoryStacks(GuiContext ctx, InventoryOverlayType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots) {
        InventoryOverlay.renderInventoryStacks(ctx, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), 0.0, 0.0);
    }

    public static void renderInventoryStacks(GuiContext ctx, InventoryOverlayType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots) {
        InventoryOverlay.renderInventoryStacks(ctx, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, disabledSlots, 0.0, 0.0);
    }

    public static void renderInventoryStacks(GuiContext ctx, InventoryOverlayType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, double mouseX, double mouseY) {
        InventoryOverlay.renderInventoryStacks(ctx, type, inv, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of(), mouseX, mouseY);
    }

    public static void renderInventoryStacks(GuiContext ctx, InventoryOverlayType type, class_1263 inv, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots, double mouseX, double mouseY) {
        if (inv == null) {
            inv = new class_1277(maxSlots > 0 ? maxSlots : InventoryOverlay.INV_PROPS_TEMP.totalSlots);
        }
        if (type == InventoryOverlayType.FURNACE) {
            InventoryOverlay.renderStackAt(ctx, inv.method_5438(0), startX + 8, startY + 8, 1.0f, mouseX, mouseY);
            InventoryOverlay.renderStackAt(ctx, inv.method_5438(1), startX + 8, startY + 44, 1.0f, mouseX, mouseY);
            InventoryOverlay.renderStackAt(ctx, inv.method_5438(2), startX + 68, startY + 26, 1.0f, mouseX, mouseY);
        } else if (type == InventoryOverlayType.BREWING_STAND) {
            InventoryOverlay.renderStackAt(ctx, inv.method_5438(0), startX + 47, startY + 42, 1.0f, mouseX, mouseY);
            InventoryOverlay.renderStackAt(ctx, inv.method_5438(1), startX + 70, startY + 49, 1.0f, mouseX, mouseY);
            InventoryOverlay.renderStackAt(ctx, inv.method_5438(2), startX + 93, startY + 42, 1.0f, mouseX, mouseY);
            InventoryOverlay.renderStackAt(ctx, inv.method_5438(3), startX + 70, startY + 8, 1.0f, mouseX, mouseY);
            InventoryOverlay.renderStackAt(ctx, inv.method_5438(4), startX + 8, startY + 8, 1.0f, mouseX, mouseY);
        } else {
            int slots = inv.method_5439();
            int x = startX;
            int y = startY;
            if (maxSlots < 0) {
                maxSlots = slots;
            }
            int slot = startSlot;
            int i = 0;
            while (slot < slots && i < maxSlots) {
                for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                    class_1799 stack = inv.method_5438(slot).method_7972();
                    if (disabledSlots.contains(slot)) {
                        InventoryOverlay.renderLockedSlotAt(ctx, x - 1, y - 1, 1.0f, mouseX, mouseY);
                    } else if (!stack.method_7960()) {
                        InventoryOverlay.renderStackAt(ctx, stack, x, y, 1.0f, mouseX, mouseY);
                    }
                    x += 18;
                }
                x = startX;
                y += 18;
            }
        }
        if (hoveredStack != null) {
            class_1799 stack = hoveredStack.method_7972();
            hoveredStack = null;
            InventoryOverlay.renderStackToolTipStyled(ctx, (int)mouseX, (int)mouseY, stack);
        }
    }

    public static void renderEquipmentStacks(GuiContext ctx, class_1309 entity, int x, int y) {
        InventoryOverlay.renderEquipmentStacks(ctx, entity, x, y, 0.0, 0.0);
    }

    public static void renderEquipmentStacks(GuiContext ctx, class_1309 entity, int x, int y, double mouseX, double mouseY) {
        int i = 0;
        int xOff = 7;
        int yOff = 7;
        while (i < 4) {
            class_1304 eqSlot = VALID_EQUIPMENT_SLOTS[i];
            class_1799 stack = entity.method_6118(eqSlot);
            if (!stack.method_7960()) {
                InventoryOverlay.renderStackAt(ctx, stack.method_7972(), x + xOff + 1, y + yOff + 1, 1.0f, mouseX, mouseY);
            }
            ++i;
            yOff += 18;
        }
        class_1799 stack = entity.method_6118(class_1304.field_6173);
        if (!stack.method_7960()) {
            InventoryOverlay.renderStackAt(ctx, stack.method_7972(), x + 28, y + 36 + 7 + 1, 1.0f, mouseX, mouseY);
        }
        if (!(stack = entity.method_6118(class_1304.field_6171)).method_7960()) {
            InventoryOverlay.renderStackAt(ctx, stack.method_7972(), x + 28, y + 54 + 7 + 1, 1.0f, mouseX, mouseY);
        }
        if (hoveredStack != null) {
            stack = hoveredStack.method_7972();
            hoveredStack = null;
            InventoryOverlay.renderStackToolTipStyled(ctx, (int)mouseX, (int)mouseY, stack);
        }
    }

    public static void renderItemStacks(GuiContext ctx, class_2371<@NotNull class_1799> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots) {
        InventoryOverlay.renderItemStacks(ctx, items, startX, startY, slotsPerRow, startSlot, maxSlots, Set.of());
    }

    public static void renderItemStacks(GuiContext ctx, class_2371<@NotNull class_1799> items, int startX, int startY, int slotsPerRow, int startSlot, int maxSlots, Set<Integer> disabledSlots) {
        int slots = items.size();
        int x = startX;
        int y = startY;
        if (maxSlots < 0) {
            maxSlots = slots;
        }
        int slot = startSlot;
        int i = 0;
        while (slot < slots && i < maxSlots) {
            for (int column = 0; column < slotsPerRow && slot < slots && i < maxSlots; ++column, ++slot, ++i) {
                class_1799 stack = ((class_1799)items.get(slot)).method_7972();
                if (disabledSlots.contains(slot)) {
                    InventoryOverlay.renderLockedSlotAt(ctx, x - 1, y - 1, 1.0f, 0.0, 0.0);
                } else if (!stack.method_7960()) {
                    InventoryOverlay.renderStackAt(ctx, stack, x, y, 1.0f);
                }
                x += 18;
            }
            x = startX;
            y += 18;
        }
    }

    public static void renderStackAt(GuiContext ctx, class_1799 stack, float x, float y, float scale) {
        InventoryOverlay.renderStackAt(ctx, stack, x, y, scale, 0.0, 0.0);
    }

    public static void renderStackAt(GuiContext ctx, class_1799 stack, float x, float y, float scale, double mouseX, double mouseY) {
        ctx.method_51448().pushMatrix();
        ctx.method_51448().translate(x, y);
        ctx.method_51448().scale(scale, scale);
        ctx.method_51427(stack.method_7972(), 0, 0);
        ctx.method_51431(ctx.fontRenderer(), stack.method_7972(), 0, 0);
        ctx.method_51448().popMatrix();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = stack.method_7972();
        }
    }

    public static void renderLockedSlotAt(GuiContext ctx, float x, float y, float scale, double mouseX, double mouseY) {
        int color = -1;
        ctx.method_51448().pushMatrix();
        ctx.method_51448().translate(x, y);
        ctx.method_51448().scale(scale, scale);
        ctx.method_52707(class_10799.field_56883, TEXTURE_LOCKED_SLOT, 0, 0, 18, 18, color);
        ctx.method_51448().popMatrix();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = null;
        }
    }

    public static void renderBackgroundSlotAt(GuiContext ctx, class_2960 texture, float x, float y) {
        InventoryOverlay.renderBackgroundSlotAt(ctx, texture, x, y, 0.9f, 0.0, 0.0);
    }

    public static void renderBackgroundSlotAt(GuiContext ctx, class_2960 texture, float x, float y, float scale, double mouseX, double mouseY) {
        int color = -1;
        ctx.method_51448().pushMatrix();
        ctx.method_51448().translate(x, y);
        ctx.method_51448().scale(scale, scale);
        ctx.method_52707(class_10799.field_56883, texture, 0, 0, 18, 18, color);
        ctx.method_51448().popMatrix();
        if (mouseX >= (double)x && mouseX < (double)(x + 16.0f * scale) && mouseY >= (double)y && mouseY < (double)(y + 16.0f * scale)) {
            hoveredStack = null;
        }
    }

    public static void renderStackToolTip(GuiContext ctx, int x, int y, class_1799 stack) {
        if (!stack.method_7960()) {
            List<class_2561> toolTips = ctx.itemTooltips(stack);
            ArrayList<String> lines = new ArrayList<String>();
            for (int i = 0; i < toolTips.size(); ++i) {
                if (i == 0) {
                    lines.add(String.valueOf(stack.method_7932().method_58413()) + toolTips.get(i).getString());
                    continue;
                }
                lines.add(GuiBase.TXT_DARK_GRAY + toolTips.get(i).getString());
            }
            RenderUtils.drawHoverText(ctx, x, y, lines);
        }
    }

    public static void renderStackToolTipStyled(GuiContext ctx, int x, int y, class_1799 stack) {
        if (!stack.method_7960()) {
            List<class_2561> toolTips = ctx.itemTooltips(stack);
            ArrayList<class_5684> list = new ArrayList<class_5684>(toolTips.stream().map(class_2561::method_30937).map(class_5684::method_32662).toList());
            Optional data = stack.method_32347();
            data.ifPresent(tooltipData -> list.add(list.isEmpty() ? 0 : 1, class_5684.method_32663((class_5632)tooltipData)));
            ctx.method_51435(ctx.fontRenderer(), list, x, y, class_8001.field_41687, (class_2960)stack.method_58694(class_9334.field_54198));
            ((RenderEventHandler)RenderEventHandler.getInstance()).onRenderTooltipLast(ctx, stack, x, y);
        }
    }

    private static void dumpStack(class_1799 stack, @Nullable List<class_2561> list) {
        if (stack.method_7960()) {
            LOGGER.info("dumpStack(): [{}]", class_1799.field_8037.toString());
            return;
        }
        class_5455 registry = WorldUtils.getBestWorld(class_310.method_1551()).method_30349();
        LOGGER.info("dumpStack(): [{}}]", class_1799.field_24671.encodeStart((DynamicOps)registry.method_57093((DynamicOps)class_2509.field_11560), (Object)stack).getPartialOrThrow());
        if (list != null && !list.isEmpty()) {
            int i = 0;
            for (class_2561 entry : list) {
                LOGGER.info("ToolTip[{}]: {}", i, entry.getString());
                ++i;
            }
        }
    }

    public static class InventoryProperties {
        public int totalSlots = 1;
        public int width = 176;
        public int height = 83;
        public int slotsPerRow = 9;
        public int slotOffsetX = 8;
        public int slotOffsetY = 8;
    }

    @Deprecated(forRemoval=true)
    public static interface Refresher {
        public Context onContextRefresh(Context var1, class_1937 var2);
    }

    @Deprecated(forRemoval=true)
    public record Context(InventoryRenderType type, @Nullable class_1263 inv, @Nullable class_2586 be, @Nullable class_1309 entity, @Nullable class_2487 nbt, Refresher handler) {
    }

    @Deprecated(forRemoval=true)
    public static enum InventoryRenderType {
        BREWING_STAND,
        CRAFTER,
        DISPENSER,
        FURNACE,
        HOPPER,
        HORSE,
        LLAMA,
        WOLF,
        HAPPY_GHAST,
        COPPER_GOLEM,
        FIXED_27,
        FIXED_54,
        VILLAGER,
        PLAYER,
        ENDER_CHEST,
        BOOKSHELF,
        WALL_SHELF,
        SINGLE_ITEM,
        BUNDLE,
        ARMOR_STAND,
        LIVING_ENTITY,
        GENERIC;

    }
}

