/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.config.options.table;

import fi.dy.masa.malilib.config.options.table.Label;
import fi.dy.masa.malilib.config.options.table.type.BooleanEntry;
import fi.dy.masa.malilib.config.options.table.type.DoubleEntry;
import fi.dy.masa.malilib.config.options.table.type.Entry;
import fi.dy.masa.malilib.config.options.table.type.IntegerEntry;
import fi.dy.masa.malilib.config.options.table.type.LabelEntry;
import fi.dy.masa.malilib.config.options.table.type.StringEntry;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public record TableRow(List<Entry> list) {
    public TableRow() {
        this(new ArrayList<Entry>());
    }

    public TableRow(Entry ... objs) {
        this(new ArrayList<Entry>());
        Collections.addAll(this.list, objs);
    }

    public static TableRow of(Entry ... entries) {
        TableRow tableRow = new TableRow();
        for (Entry entry : entries) {
            tableRow.add(entry);
        }
        return tableRow;
    }

    public static TableRow of(Object ... entries) {
        TableRow tableRow = new TableRow();
        block8: for (Object entry : entries) {
            Object object;
            Objects.requireNonNull(entry);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Integer.class, Double.class, Boolean.class, Label.class, Entry.class}, (Object)object, n)) {
                case 0: {
                    String s = (String)object;
                    tableRow.add(new StringEntry(s));
                    continue block8;
                }
                case 1: {
                    Integer i = (Integer)object;
                    tableRow.add(new IntegerEntry(i));
                    continue block8;
                }
                case 2: {
                    Double v = (Double)object;
                    tableRow.add(new DoubleEntry(v));
                    continue block8;
                }
                case 3: {
                    Boolean b = (Boolean)object;
                    tableRow.add(new BooleanEntry(b));
                    continue block8;
                }
                case 4: {
                    Label l = (Label)object;
                    tableRow.add(new LabelEntry(l));
                    continue block8;
                }
                case 5: {
                    Entry e = (Entry)object;
                    tableRow.add(e);
                    continue block8;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported entry type: " + entry.getClass().getName());
                }
            }
        }
        return tableRow;
    }

    public void add(Entry entry) {
        this.list.add(entry);
    }

    public Entry get(int index) {
        return this.list.get(index);
    }

    public IntegerEntry getIntEntry(int index) {
        return (IntegerEntry)this.list.get(index);
    }

    public DoubleEntry getDoubleEntry(int index) {
        return (DoubleEntry)this.list.get(index);
    }

    public BooleanEntry getBooleanEntry(int index) {
        return (BooleanEntry)this.list.get(index);
    }

    public StringEntry getStringEntry(int index) {
        return (StringEntry)this.list.get(index);
    }

    public LabelEntry getLabelEntry(int index) {
        return (LabelEntry)this.list.get(index);
    }

    public Integer getInt(int index) {
        return ((IntegerEntry)this.list.get(index)).getValue();
    }

    public Double getDouble(int index) {
        return ((DoubleEntry)this.list.get(index)).getValue();
    }

    public Boolean getBoolean(int index) {
        return ((BooleanEntry)this.list.get(index)).getValue();
    }

    public String getString(int index) {
        return ((StringEntry)this.list.get(index)).getValue();
    }

    public Label getLabel(int index) {
        return ((LabelEntry)this.list.get(index)).getValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object other) {
        List<Entry> list1;
        if (!(other instanceof TableRow)) return false;
        TableRow tableRow = (TableRow)other;
        try {
            List<Entry> list;
            list1 = list = tableRow.list();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        if (this.list.size() != list1.size()) {
            return false;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i).equals(list1.get(i))) continue;
            return false;
        }
        return true;
    }
}

