/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.util.StructureType;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_3195;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3449;
import net.minecraft.class_5847;
import org.jetbrains.annotations.NotNull;

public class StructureData {
    private final StructureType type;
    private final IntBoundingBox mainBox;
    private final ImmutableList<@NotNull IntBoundingBox> componentBoxes;
    private long refreshTime;
    @Nullable
    private final class_3449 vanilla;

    private StructureData(StructureType type, ImmutableList<@NotNull IntBoundingBox> componentBoxes, long refreshTime, boolean shouldExpandBox) {
        this.type = type;
        this.vanilla = null;
        this.mainBox = StructureData.encompass(componentBoxes, shouldExpandBox);
        this.componentBoxes = componentBoxes;
        this.refreshTime = refreshTime;
    }

    private StructureData(StructureType type, ImmutableList<@NotNull IntBoundingBox> componentBoxes, class_3449 structureStart) {
        this.type = type;
        this.vanilla = structureStart;
        this.mainBox = IntBoundingBox.fromVanillaBox((class_3341)structureStart.method_14969());
        this.componentBoxes = componentBoxes;
    }

    public StructureType getStructureType() {
        return this.type;
    }

    @Nullable
    public class_3449 toVanilla() {
        return this.vanilla;
    }

    public boolean shouldExpandBox(class_3195 structure) {
        return structure.method_42701() != class_5847.field_28922;
    }

    public IntBoundingBox getBoundingBox() {
        return this.mainBox;
    }

    public ImmutableList<@NotNull IntBoundingBox> getComponents() {
        return this.componentBoxes;
    }

    public long getRefreshTime() {
        return this.refreshTime;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static StructureData fromStructureStart(StructureType type, class_3449 structure) {
        // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull ImmutableList.Builder builder = ImmutableList.builder();
        List components = structure.method_14963();
        for (class_3443 component : components) {
            builder.add((Object)IntBoundingBox.fromVanillaBox((class_3341)component.method_14935()));
        }
        return new StructureData(type, (ImmutableList<IntBoundingBox>)builder.build(), structure);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @Nullable
    public static StructureData fromStructureStartTag(class_2487 tag, long currentTime) {
        if (tag.method_10545("id") && tag.method_10545("Children")) {
            String id = tag.method_68564("id", "?");
            StructureType type = StructureType.fromStructureId(id);
            if (type == StructureType.UNKNOWN && Configs.Generic.DEBUG_MESSAGES.getBooleanValue()) {
                MiniHUD.LOGGER.warn("StructureData.fromStructureStartTag(): Unknown structure type '{}'", (Object)id);
            }
            try {
                // Could not load outer class - annotation placement on inner may be incorrect
                @NotNull ImmutableList.Builder builder = ImmutableList.builder();
                class_2499 pieces = tag.method_68569("Children");
                boolean shouldExpandBox = tag.method_68566("ExpandBox", false);
                int count = pieces.size();
                for (int i = 0; i < count; ++i) {
                    class_2487 pieceTag = pieces.method_68582(i);
                    builder.add((Object)IntBoundingBox.fromArray((int[])((int[])pieceTag.method_10561("BB").orElseThrow())));
                }
                return new StructureData(type, (ImmutableList<IntBoundingBox>)builder.build(), currentTime, shouldExpandBox);
            }
            catch (Exception e) {
                MiniHUD.LOGGER.warn("StructureData.fromStructureStartTag(): Failed to parse structure [{}] data; {}", (Object)id, (Object)e.getLocalizedMessage());
            }
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.componentBoxes == null ? 0 : this.componentBoxes.hashCode());
        result = 31 * result + (this.mainBox == null ? 0 : this.mainBox.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        StructureData other = (StructureData)obj;
        if (this.componentBoxes == null ? other.componentBoxes != null : !this.componentBoxes.equals(other.componentBoxes)) {
            return false;
        }
        if (this.mainBox == null ? other.mainBox != null : !this.mainBox.equals((Object)other.mainBox)) {
            return false;
        }
        return this.type == other.type;
    }

    public static IntBoundingBox encompass(Iterable<IntBoundingBox> boxes, boolean expandBox) {
        Iterator<IntBoundingBox> iterator = boxes.iterator();
        if (iterator.hasNext()) {
            IntBoundingBox box = iterator.next();
            int minX = box.minX();
            int minY = box.minY();
            int minZ = box.minZ();
            int maxX = box.maxX();
            int maxY = box.maxY();
            int maxZ = box.maxZ();
            while (iterator.hasNext()) {
                box = iterator.next();
                minX = Math.min(minX, box.minX());
                minY = Math.min(minY, box.minY());
                minZ = Math.min(minZ, box.minZ());
                maxX = Math.max(maxX, box.maxX());
                maxY = Math.max(maxY, box.maxY());
                maxZ = Math.max(maxZ, box.maxZ());
            }
            IntBoundingBox bb = new IntBoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
            if (expandBox) {
                bb = bb.expand(12);
            }
            return bb;
        }
        return new IntBoundingBox(0, 0, 0, 0, 0, 0);
    }
}

