/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.malilib.config.IConfigOptionListEntry;
import fi.dy.masa.malilib.util.StringUtils;

public enum SpeedUnits implements IConfigOptionListEntry
{
    MPS("mps", "minihud.label.speed_units.mps", mps -> mps),
    KMPH("kmph", "minihud.label.speed_units.kmph", mps -> mps * 3.6),
    FPS("fps", "minihud.label.speed_units.fps", mps -> mps * 3.28084),
    MPH("mph", "minihud.label.speed_units.mph", mps -> mps * 2.23694),
    C("c", "minihud.label.speed_units.c", mps -> mps / 2.99792458E8),
    MACH("mach", "minihud.label.speed_units.mach", mps -> mps / 343.0);

    private static final ImmutableList<SpeedUnits> VALUES;
    private final String configString;
    private final String translationKey;
    private final Conversion conversion;
    public final String suffix;

    private SpeedUnits(String configString, String translationKey, Conversion conversion) {
        this.configString = configString;
        this.translationKey = translationKey;
        this.conversion = conversion;
        this.suffix = configString;
    }

    public double convert(double metersPerSecond) {
        return this.conversion.convert(metersPerSecond);
    }

    public String getStringValue() {
        return this.configString;
    }

    public String getDisplayName() {
        return StringUtils.translate((String)this.translationKey, (Object[])new Object[0]);
    }

    public SpeedUnits cycle(boolean forward) {
        int id = this.ordinal();
        if (forward) {
            if (++id >= SpeedUnits.values().length) {
                id = 0;
            }
        } else if (--id < 0) {
            id = SpeedUnits.values().length - 1;
        }
        return SpeedUnits.values()[id % SpeedUnits.values().length];
    }

    public SpeedUnits fromString(String name) {
        return SpeedUnits.fromStringStatic(name);
    }

    public static SpeedUnits fromStringStatic(String name) {
        for (SpeedUnits val : VALUES) {
            if (!val.configString.equalsIgnoreCase(name)) continue;
            return val;
        }
        return MPS;
    }

    static {
        VALUES = ImmutableList.copyOf((Object[])SpeedUnits.values());
    }

    private static interface Conversion {
        public double convert(double var1);
    }
}

