/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.malilib.util.data.DataBlockUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.malilib.util.time.DurationFormat;
import fi.dy.masa.malilib.util.time.TimeFormat;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.data.HudDataManager;
import fi.dy.masa.minihud.mixin.block.IMixinAbstractFurnaceBlockEntity;
import fi.dy.masa.minihud.util.DataStorage;
import fi.dy.masa.minihud.util.InventoryUtils;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_10706;
import net.minecraft.class_11580;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1874;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2609;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_4482;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5762;
import net.minecraft.class_8786;
import net.minecraft.class_8824;
import net.minecraft.class_9275;
import net.minecraft.class_9276;
import net.minecraft.class_9280;
import net.minecraft.class_9291;
import net.minecraft.class_9334;
import org.apache.commons.lang3.math.Fraction;

public class MiscUtils {
    private static final Random RAND = new Random();
    private static final int[] AXOLOTL_COLORS = new int[]{16762860, 9202768, 16438299, 15267835, 11974142};

    public static long bytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static double intAverage(int[] values) {
        long sum = 0L;
        for (int value : values) {
            sum += (long)value;
        }
        return (double)sum / (double)values.length;
    }

    public static long longAverage(long[] values) {
        long sum = 0L;
        for (long value : values) {
            sum += value;
        }
        return sum / (long)values.length;
    }

    public static boolean canSlimeSpawnAt(int posX, int posZ, long worldSeed) {
        return MiscUtils.canSlimeSpawnInChunk(posX >> 4, posZ >> 4, worldSeed);
    }

    public static boolean canSlimeSpawnInChunk(int chunkX, int chunkZ, long worldSeed) {
        long slimeSeed = 987234911L;
        long rngSeed = worldSeed + (long)(chunkX * chunkX * 4987142) + (long)(chunkX * 5947611) + (long)(chunkZ * chunkZ) * 4392871L + (long)(chunkZ * 389711) ^ slimeSeed;
        RAND.setSeed(rngSeed);
        return RAND.nextInt(10) == 0;
    }

    public static boolean isOverworld(class_1937 world) {
        return world.method_27983() == class_1937.field_25179;
    }

    public static boolean isStructureWithinRange(@Nullable class_3341 bb, class_2338 playerPos, int maxRange) {
        return bb != null && playerPos.method_10263() >= bb.method_35415() - maxRange && playerPos.method_10263() <= bb.method_35418() + maxRange && playerPos.method_10260() >= bb.method_35417() - maxRange && playerPos.method_10260() <= bb.method_35420() + maxRange;
    }

    public static boolean isStructureWithinRange(@Nullable IntBoundingBox bb, class_2338 playerPos, int maxRange) {
        return bb != null && playerPos.method_10263() >= bb.minX() - maxRange && playerPos.method_10263() <= bb.maxX() + maxRange && playerPos.method_10260() >= bb.minZ() - maxRange && playerPos.method_10260() <= bb.maxZ() + maxRange;
    }

    public static boolean areBoxesEqual(IntBoundingBox bb1, IntBoundingBox bb2) {
        return bb1.minX() == bb2.minX() && bb1.minY() == bb2.minY() && bb1.minZ() == bb2.minZ() && bb1.maxX() == bb2.maxX() && bb1.maxY() == bb2.maxY() && bb1.maxZ() == bb2.maxZ();
    }

    public static int getSpawnableChunksCount(@Nonnull class_3218 world) {
        return world.method_14178().field_17254.method_17263().method_14052();
    }

    public static void addAxolotlTooltip(class_1799 stack, Consumer<class_2561> lines) {
        class_5762.class_5767 variant = (class_5762.class_5767)stack.method_57353().method_58695(class_9334.field_56140, (Object)class_5762.class_5767.field_28341);
        int variantId = variant.method_33233();
        String variantName = variant.method_33238();
        class_5250 labelText = class_2561.method_43471((String)"minihud.label.axolotl_tooltip.label");
        class_5250 valueText = class_2561.method_43469((String)"minihud.label.axolotl_tooltip.value", (Object[])new Object[]{variantName, variantId});
        if (variantId < AXOLOTL_COLORS.length) {
            valueText.method_10862(class_2583.field_24360.method_36139(AXOLOTL_COLORS[variantId]));
        }
        lines.accept((class_2561)labelText.method_10852((class_2561)valueText));
    }

    public static void addBeeTooltip(class_1799 stack, Consumer<class_2561> lines) {
        class_10706 bees = (class_10706)stack.method_57353().method_58695(class_9334.field_49624, (Object)class_10706.field_56300);
        List beeList = bees.comp_3585();
        if (beeList != null && !beeList.isEmpty()) {
            int count = beeList.size();
            int babyCount = 0;
            for (class_4482.class_9309 beeOccupant : beeList) {
                DataResult dr;
                class_2520 nbtName;
                class_11580 beeData = beeOccupant.comp_2431();
                class_2487 beeTag = beeData.method_72540();
                int beeTicks = beeOccupant.comp_2432();
                Optional<class_2561> beeName = Optional.empty();
                int beeAge = -1;
                if (beeTag.method_10545("CustomName") && (nbtName = beeTag.method_10580("CustomName")) != null && (dr = class_8824.field_46597.parse((DynamicOps)DataStorage.getInstance().getWorldRegistryManager().method_57093((DynamicOps)class_2509.field_11560), (Object)nbtName)).isSuccess()) {
                    beeName = Optional.of((class_2561)dr.getPartialOrThrow());
                }
                if (beeTag.method_10545("Age")) {
                    beeAge = beeTag.method_68083("Age", 0);
                }
                if (beeAge + beeTicks < 0) {
                    ++babyCount;
                }
                beeName.ifPresent(text -> lines.accept((class_2561)class_2561.method_43469((String)"minihud.label.bee_tooltip.name", (Object[])new Object[]{text})));
            }
            if (babyCount > 0) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.bee_tooltip.count_babies", (Object[])new Object[]{String.valueOf(count), String.valueOf(babyCount)}));
            } else {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.bee_tooltip.count", (Object[])new Object[]{String.valueOf(count)}));
            }
        }
    }

    public static void addBundleTooltip(class_1799 stack, Consumer<class_2561> lines) {
        class_9276 bundleData = (class_9276)stack.method_58694(class_9334.field_49650);
        int maxCount = Configs.Generic.BUNDLE_TOOLTIPS_FILL_LEVEL.getIntegerValue();
        if (bundleData != null) {
            float fillPercent;
            int count;
            Fraction occupancy = bundleData.method_57428();
            if (maxCount != 64) {
                count = InventoryUtils.recalculateBundleSize(bundleData, maxCount);
                fillPercent = 100.0f * ((float)count / (float)maxCount);
            } else {
                count = class_3532.method_59515((Fraction)occupancy, (int)maxCount);
                fillPercent = 100.0f * occupancy.floatValue();
            }
            if (count > maxCount) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.bundle_tooltip.count.full", (Object[])new Object[]{count, maxCount, Float.valueOf(fillPercent)}));
            } else {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.bundle_tooltip.count", (Object[])new Object[]{count, maxCount, Float.valueOf(fillPercent)}));
            }
        }
    }

    public static void addHoneyTooltip(class_1799 stack, Consumer<class_2561> lines) {
        class_9275 blockItemState = (class_9275)stack.method_57353().method_58694(class_9334.field_49623);
        if (blockItemState != null && !blockItemState.method_57414()) {
            Integer honey = (Integer)blockItemState.method_57418((class_2769)class_2741.field_20432);
            String honeyLevel = "0";
            if (honey != null && honey >= 0 && honey <= 5) {
                honeyLevel = String.valueOf(honey);
            }
            lines.accept(StringUtils.translateAsText((String)"minihud.label.honey_info.level", (Object[])new Object[]{honeyLevel}));
        }
    }

    public static void addCustomModelTooltip(class_1799 stack, Consumer<class_2561> lines) {
        class_9280 data = (class_9280)stack.method_58694(class_9334.field_49637);
        if (data != null) {
            Float aFloat = data.method_65362(0);
            Boolean aFlag = data.method_65365(0);
            String aString = data.method_65366(0);
            Integer aColor = data.method_65367(0);
            if (aFloat != null) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.custom_model_data_tooltip.float", (Object[])new Object[]{aFloat}));
            }
            if (aFlag != null) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.custom_model_data_tooltip.flag", (Object[])new Object[]{aFlag}));
            }
            if (aString != null) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.custom_model_data_tooltip.string", (Object[])new Object[]{aString}));
            }
            if (aColor != null) {
                lines.accept(StringUtils.translateAsText((String)"minihud.label.custom_model_data_tooltip.color", (Object[])new Object[]{aColor}));
            }
        }
    }

    public static void addFoodTooltip(class_1799 stack, Consumer<class_2561> lines) {
        class_4174 data = (class_4174)stack.method_58694(class_9334.field_50075);
        if (data != null) {
            lines.accept(StringUtils.translateAsText((String)"minihud.label.food_tooltip", (Object[])new Object[]{Float.valueOf((float)data.comp_2491() / 2.0f), Float.valueOf(data.comp_2492())}));
        }
    }

    public static void addLodestoneTooltip(class_1799 stack, Consumer<class_2561> lines) {
        class_9291 data = (class_9291)stack.method_58694(class_9334.field_49614);
        if (data != null && data.comp_2402().isPresent()) {
            class_4208 pos = (class_4208)data.comp_2402().get();
            lines.accept(StringUtils.translateAsText((String)"minihud.label.lodestone_tooltip", (Object[])new Object[]{pos.comp_2207().method_29177().method_12832(), pos.comp_2208().method_23854()}));
        }
    }

    public static int getFurnaceXpAmount(class_3218 world, class_2609 be) {
        Reference2IntOpenHashMap<class_5321<class_1860<?>>> recipes = ((IMixinAbstractFurnaceBlockEntity)be).minihud_getUsedRecipes();
        double xp = 0.0;
        if (recipes == null || recipes.isEmpty()) {
            return -1;
        }
        for (Reference2IntMap.Entry entry : recipes.reference2IntEntrySet()) {
            class_8786 recipeEntry = world.method_64577().method_8130((class_5321)entry.getKey()).orElse(null);
            if (recipeEntry == null) continue;
            xp += (double)((float)entry.getIntValue() * ((class_1874)recipeEntry.comp_1933()).method_8171());
        }
        return (int)xp;
    }

    public static int getFurnaceXpAmount(class_3218 world, @Nonnull CompoundData data) {
        Reference2IntOpenHashMap recipes = DataBlockUtils.getRecipesUsed((CompoundData)data);
        double xp = 0.0;
        if (recipes.isEmpty()) {
            return -1;
        }
        for (Reference2IntMap.Entry entry : recipes.reference2IntEntrySet()) {
            class_8786 recipeEntry = world.method_64577().method_8130((class_5321)entry.getKey()).orElse(null);
            if (recipeEntry == null) continue;
            xp += (double)((float)entry.getIntValue() * ((class_1874)recipeEntry.comp_1933()).method_8171());
        }
        return (int)xp;
    }

    public static int getFurnaceXpAmount(class_2609 be) {
        Reference2IntOpenHashMap<class_5321<class_1860<?>>> recipes = ((IMixinAbstractFurnaceBlockEntity)be).minihud_getUsedRecipes();
        double xp = 0.0;
        if (recipes == null || recipes.isEmpty() || HudDataManager.getInstance().getPreparedRecipes() == null) {
            return -1;
        }
        for (Reference2IntMap.Entry entry : recipes.reference2IntEntrySet()) {
            class_8786 recipeEntry = HudDataManager.getInstance().getPreparedRecipes().method_64696((class_5321)entry.getKey());
            if (recipeEntry == null) continue;
            xp += (double)((float)entry.getIntValue() * ((class_1874)recipeEntry.comp_1933()).method_8171());
        }
        return (int)xp;
    }

    public static int getFurnaceXpAmount(@Nonnull CompoundData data) {
        Reference2IntOpenHashMap recipes = DataBlockUtils.getRecipesUsed((CompoundData)data);
        double xp = 0.0;
        if (recipes.isEmpty() || HudDataManager.getInstance().getPreparedRecipes() == null) {
            return -1;
        }
        for (Reference2IntMap.Entry entry : recipes.reference2IntEntrySet()) {
            class_8786 recipeEntry = HudDataManager.getInstance().getPreparedRecipes().method_64696((class_5321)entry.getKey());
            if (recipeEntry == null) continue;
            xp += (double)((float)entry.getIntValue() * ((class_1874)recipeEntry.comp_1933()).method_8171());
        }
        return (int)xp;
    }

    public static String formatDateNow() {
        return MiscUtils.formatDateFromEpoch(-1L);
    }

    public static String formatDateFromEpoch(long epochMs) {
        TimeFormat type = (TimeFormat)Configs.Generic.DATE_FORMAT_TYPE.getOptionListValue();
        if (epochMs < 0L) {
            return type.formatNow(Configs.Generic.DATE_FORMAT_STRING.getStringValue());
        }
        return type.formatTo(epochMs, Configs.Generic.DATE_FORMAT_STRING.getStringValue());
    }

    public static long getEpochMsFromString(String time) {
        TimeFormat type = (TimeFormat)Configs.Generic.DATE_FORMAT_TYPE.getOptionListValue();
        return type.formatFrom(time, Configs.Generic.DATE_FORMAT_STRING.getStringValue());
    }

    public static String formatDuration(long duration) {
        DurationFormat type = (DurationFormat)Configs.Generic.DURATION_FORMAT_TYPE.getOptionListValue();
        return type.format(duration, Configs.Generic.DURATION_FORMAT_STRING.getStringValue());
    }
}

