/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.position.PositionUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import fi.dy.masa.minihud.renderer.RenderUtils;
import fi.dy.masa.minihud.renderer.shapes.ShapeCircleBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import fi.dy.masa.minihud.renderer.shapes.SideQuad;
import fi.dy.masa.minihud.util.ShapeRenderType;
import fi.dy.masa.minihud.util.shape.SphereUtils;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_9801;
import org.apache.commons.lang3.StringUtils;

public class ShapeCircle
extends ShapeCircleBase {
    protected int height = 1;
    private boolean hasData = false;

    public ShapeCircle() {
        super(ShapeType.CIRCLE, Configs.Colors.SHAPE_CIRCLE.getColor(), 16.0);
        this.useCulling = true;
    }

    @Override
    public void update(class_243 cameraPos, class_1297 entity, class_310 mc, class_3695 profiler) {
        this.hasData = true;
        this.render(cameraPos, mc, profiler);
        this.needsUpdate = false;
    }

    @Override
    public boolean hasData() {
        return this.hasData;
    }

    @Override
    public void render(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.allocateBuffers(this.renderLines);
        this.renderQuads(cameraPos, mc, profiler);
        if (this.renderLines) {
            this.renderOutlines(cameraPos, mc, profiler);
        }
    }

    private void renderQuads(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        profiler.method_15396("circle_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:circle/quads", this.renderThroughShape ? MaLiLibPipelines.MINIHUD_SHAPE_NO_DEPTH_OFFSET : MaLiLibPipelines.MINIHUD_SHAPE_OFFSET_NO_CULL);
        this.renderCircleShapeQuads(cameraPos, builder);
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("ShapeCircle#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    private void renderOutlines(class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null || !this.renderLines) {
            return;
        }
        profiler.method_15396("circle_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:circle/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        this.renderCircleShapeOutlines(cameraPos, this.glLineWidth, builder);
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("ShapeCircle#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    @Override
    public void reset() {
        super.reset();
        this.hasData = false;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = class_3532.method_15340((int)height, (int)1, (int)8192);
        this.setNeedsUpdate();
    }

    protected void renderCircleShapeQuads(class_243 cameraPos, class_287 builder) {
        LongOpenHashSet positions = new LongOpenHashSet();
        Consumer<class_2338.class_2339> positionConsumer = this.getPositionCollector(positions);
        SphereUtils.RingPositionTest test = this::isPositionOnOrInsideRing;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        class_243 effectiveCenter = this.getEffectiveCenter();
        class_2350.class_2351 axis = this.mainAxis.method_10166();
        double expand = 0.0;
        if (this.getCombineQuads()) {
            mutablePos.method_10102(effectiveCenter.field_1352, effectiveCenter.field_1351, effectiveCenter.field_1350);
            if (axis == class_2350.class_2351.field_11052) {
                SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
            } else {
                SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, this.mainAxis, test);
            }
            Long2ObjectOpenHashMap<SideQuad> strips = SphereUtils.buildSphereShellToStrips(positions, axis, test, this.renderType, this.layerRange);
            List<SideQuad> quads = ShapeCircle.buildStripsToQuadsForCircle(strips, this.mainAxis, this.height);
            RenderUtils.renderQuads(quads, this.color, expand, cameraPos, builder);
        } else {
            class_2338 posCenter = class_2338.method_49638((class_2374)effectiveCenter);
            int offX = this.mainAxis.method_10148();
            int offY = this.mainAxis.method_10164();
            int offZ = this.mainAxis.method_10165();
            for (int i = 0; i < this.height; ++i) {
                mutablePos.method_10103(posCenter.method_10263() + offX * i, posCenter.method_10264() + offY * i, posCenter.method_10260() + offZ * i);
                if (axis == class_2350.class_2351.field_11052) {
                    SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
                    continue;
                }
                SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, this.mainAxis, test);
            }
            class_2350[] sides = this.getSides();
            RenderUtils.renderCircleBlockPositions(positions, sides, test, this.renderType, this.layerRange, this.color, expand, cameraPos, builder);
        }
    }

    protected void renderCircleShapeOutlines(class_243 cameraPos, float lineWidth, class_287 builder) {
        LongOpenHashSet positions = new LongOpenHashSet();
        Consumer<class_2338.class_2339> positionConsumer = this.getPositionCollector(positions);
        SphereUtils.RingPositionTest test = this::isPositionOnOrInsideRing;
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        class_243 effectiveCenter = this.getEffectiveCenter();
        class_2350.class_2351 axis = this.mainAxis.method_10166();
        double expand = 0.0;
        if (this.getCombineQuads()) {
            mutablePos.method_10102(effectiveCenter.field_1352, effectiveCenter.field_1351, effectiveCenter.field_1350);
            if (axis == class_2350.class_2351.field_11052) {
                SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
            } else {
                SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, this.mainAxis, test);
            }
            Long2ObjectOpenHashMap<SideQuad> strips = SphereUtils.buildSphereShellToStrips(positions, axis, test, this.renderType, this.layerRange);
            List<SideQuad> quads = ShapeCircle.buildStripsToQuadsForCircle(strips, this.mainAxis, this.height);
            RenderUtils.renderQuadLines(quads, this.colorLines, expand, cameraPos, lineWidth, builder);
        } else {
            class_2338 posCenter = class_2338.method_49638((class_2374)effectiveCenter);
            int offX = this.mainAxis.method_10148();
            int offY = this.mainAxis.method_10164();
            int offZ = this.mainAxis.method_10165();
            for (int i = 0; i < this.height; ++i) {
                mutablePos.method_10103(posCenter.method_10263() + offX * i, posCenter.method_10264() + offY * i, posCenter.method_10260() + offZ * i);
                if (axis == class_2350.class_2351.field_11052) {
                    SphereUtils.addPositionsOnHorizontalBlockRing(positionConsumer, mutablePos, test);
                    continue;
                }
                SphereUtils.addPositionsOnVerticalBlockRing(positionConsumer, mutablePos, this.mainAxis, test);
            }
            class_2350[] sides = this.getSides();
            RenderUtils.renderCircleBlockOutlines(positions, sides, test, this.renderType, this.layerRange, this.colorLines, expand, cameraPos, lineWidth, builder);
        }
    }

    protected class_2350[] getSides() {
        if (this.renderType != ShapeRenderType.FULL_BLOCK) {
            return SphereUtils.getDirectionsNotOnAxis(this.mainAxis.method_10166());
        }
        return PositionUtils.ALL_DIRECTIONS;
    }

    protected boolean isPositionOnOrInsideRing(int blockX, int blockY, int blockZ, class_2350 outSide) {
        class_2350.class_2351 axis = this.mainAxis.method_10166();
        class_243 effectiveCenter = this.getEffectiveCenter();
        double radiusSq = this.getSquaredRadius();
        double x = axis == class_2350.class_2351.field_11048 ? effectiveCenter.field_1352 : (double)blockX + 0.5;
        double y = axis == class_2350.class_2351.field_11052 ? effectiveCenter.field_1351 : (double)blockY + 0.5;
        double z = axis == class_2350.class_2351.field_11051 ? effectiveCenter.field_1350 : (double)blockZ + 0.5;
        double distSq = effectiveCenter.method_1028(x, y, z);
        double diff = radiusSq - distSq;
        return diff >= 0.0;
    }

    public static List<SideQuad> buildStripsToQuadsForCircle(Long2ObjectOpenHashMap<SideQuad> strips, class_2350 mainAxisDirection, int circleHeight) {
        ArrayList<SideQuad> quads = new ArrayList<SideQuad>();
        Long2ByteOpenHashMap handledPositions = new Long2ByteOpenHashMap();
        class_2350.class_2351 mainAxis = mainAxisDirection.method_10166();
        for (SideQuad strip : strips.values()) {
            class_2350 side;
            long pos = strip.startPos();
            if (SphereUtils.isHandledAndMarkHandled(pos, side = strip.side(), handledPositions)) continue;
            long startPos = side == mainAxisDirection ? SphereUtils.offsetPos(pos, mainAxisDirection, circleHeight - 1) : pos;
            int height = side.method_10166() != mainAxis ? circleHeight : strip.height();
            quads.add(new SideQuad(startPos, strip.width(), height, side));
        }
        return quads;
    }

    @Override
    public List<String> getWidgetHoverLines() {
        List<String> lines = super.getWidgetHoverLines();
        lines.add(2, fi.dy.masa.malilib.util.StringUtils.translate((String)"minihud.gui.hover.shape.circle.main_axis_value", (Object[])new Object[]{StringUtils.capitalize((String)this.getMainAxis().toString().toLowerCase())}));
        lines.add(3, fi.dy.masa.malilib.util.StringUtils.translate((String)"minihud.gui.hover.shape.height_value", (Object[])new Object[]{this.getHeight()}));
        return lines;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        if (obj != null) {
            obj.add("height", (JsonElement)new JsonPrimitive((Number)this.height));
            return obj;
        }
        return new JsonObject();
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.setHeight(JsonUtils.getInteger((JsonObject)obj, (String)"height"));
    }
}

