/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer.shapes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.renderer.shapes.ShapeBox;
import fi.dy.masa.minihud.renderer.shapes.ShapeType;
import net.minecraft.class_1297;
import net.minecraft.class_243;

public class ShapeCenteredBox
extends ShapeBox {
    protected double width = 16.0;
    protected double depth = 16.0;
    protected double height = 16.0;
    protected class_243 center = class_243.field_1353;

    public ShapeCenteredBox() {
        super(ShapeType.CENTERED_BOX, Configs.Colors.SHAPE_BOX.getColor());
    }

    @Override
    public void onShapeInit() {
        super.onShapeInit();
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        if (cameraEntity != null && this.center == class_243.field_1353) {
            this.setCenter(cameraEntity.method_73189());
        }
    }

    protected void setBoxFromDimension() {
        this.corner1 = new class_243(this.center.field_1352 - this.width / 2.0, this.center.field_1351 - this.height / 2.0, this.center.field_1350 - this.depth / 2.0);
        this.corner2 = new class_243(this.center.field_1352 + this.width / 2.0, this.center.field_1351 + this.height / 2.0, this.center.field_1350 + this.depth / 2.0);
        this.setBoxFromCorners();
    }

    public void setCenter(class_243 center) {
        this.center = center;
        this.setBoxFromDimension();
    }

    public void setWidth(double width) {
        this.width = Math.max(width, 0.0);
        this.setBoxFromDimension();
    }

    public void setDepth(double depth) {
        this.depth = Math.max(depth, 0.0);
        this.setBoxFromDimension();
    }

    public void setHeight(double height) {
        this.height = Math.max(height, 0.0);
        this.setBoxFromDimension();
    }

    public class_243 getCenter() {
        return this.center;
    }

    public double getWidth() {
        return this.width;
    }

    public double getDepth() {
        return this.depth;
    }

    public double getHeight() {
        return this.height;
    }

    @Override
    public JsonObject toJson() {
        JsonObject obj = super.toJson();
        if (obj != null) {
            obj.addProperty("width", (Number)this.width);
            obj.addProperty("height", (Number)this.height);
            obj.addProperty("depth", (Number)this.depth);
            obj.add("center", (JsonElement)JsonUtils.vec3dToJson((class_243)this.center));
            return obj;
        }
        return new JsonObject();
    }

    @Override
    public void fromJson(JsonObject obj) {
        super.fromJson(obj);
        this.center = JsonUtils.vec3dFromJson((JsonObject)obj, (String)"center");
        this.width = JsonUtils.getDouble((JsonObject)obj, (String)"width");
        this.depth = JsonUtils.getDouble((JsonObject)obj, (String)"depth");
        this.height = JsonUtils.getDouble((JsonObject)obj, (String)"height");
        this.setBoxFromDimension();
    }
}

