/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.mixin.render.IMixinAbstractTexture;
import fi.dy.masa.malilib.mixin.render.IMixinBufferBuilder;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.minihud.MiniHUD;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1049;
import net.minecraft.class_10539;
import net.minecraft.class_11219;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_4184;
import net.minecraft.class_8251;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class RenderObjectVbo {
    private Supplier<String> name;
    private RenderPipeline shader;
    private GpuBuffer vertexBuffer;
    @Nullable
    private GpuBuffer indexBuffer;
    private RenderSystem.class_5590 shapeIndex;
    private VertexFormat.class_5595 indexType;
    private class_9799 alloc;
    private class_287 builder;
    private VertexFormat format;
    private VertexFormat.class_5596 drawMode;
    private final HashMap<Integer, class_1049> textures;
    @Nullable
    private class_9801.class_9802 sortState;
    private float[] offset;
    private int color;
    private boolean started;
    private boolean uploaded;
    private int indexCount;

    protected RenderObjectVbo(Supplier<String> name, RenderPipeline shader) {
        this.name = name;
        this.alloc = new class_9799(shader.getVertexFormat().getVertexSize() * 4);
        this.builder = new class_287(this.alloc, shader.getVertexFormatMode(), shader.getVertexFormat());
        this.shapeIndex = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)shader.getVertexFormatMode());
        this.indexType = this.shapeIndex.method_31924();
        this.format = shader.getVertexFormat();
        this.drawMode = shader.getVertexFormatMode();
        this.shader = shader;
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.sortState = null;
        this.indexCount = -1;
        this.textures = new HashMap();
        this.offset = new float[]{0.0f, 0.0f, 0.0f};
        this.color = -1;
        this.started = true;
        this.uploaded = false;
    }

    public class_287 start(Supplier<String> name, RenderPipeline shader) {
        this.reset();
        this.name = name;
        this.alloc = new class_9799(shader.getVertexFormat().getVertexSize() * 4);
        this.builder = new class_287(this.alloc, shader.getVertexFormatMode(), shader.getVertexFormat());
        this.shapeIndex = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)shader.getVertexFormatMode());
        this.indexType = this.shapeIndex.method_31924();
        this.format = shader.getVertexFormat();
        this.drawMode = shader.getVertexFormatMode();
        this.shader = shader;
        this.vertexBuffer = null;
        this.indexBuffer = null;
        this.sortState = null;
        this.indexCount = -1;
        this.offset = new float[]{0.0f, 0.0f, 0.0f};
        this.color = -1;
        this.started = true;
        this.uploaded = false;
        return this.builder;
    }

    protected boolean isStarted() {
        return this.started;
    }

    protected boolean isUploaded() {
        return this.uploaded;
    }

    public String getName() {
        return this.name.get();
    }

    protected class_287 getBuilder() {
        return this.builder;
    }

    public VertexFormat getVertexFormat() {
        return this.format;
    }

    public VertexFormat.class_5596 getDrawMode() {
        return this.drawMode;
    }

    public VertexFormat getShaderFormat() {
        if (this.shader != null) {
            return this.shader.getVertexFormat();
        }
        return this.format;
    }

    public VertexFormat.class_5596 getShaderDrawMode() {
        if (this.shader != null) {
            return this.shader.getVertexFormatMode();
        }
        return this.drawMode;
    }

    protected RenderObjectVbo setBuilder(class_287 builder) throws RuntimeException {
        this.ensureBuilding(builder);
        this.builder = builder;
        return this;
    }

    protected RenderObjectVbo offset(float[] value) {
        if (value.length != 3) {
            value = new float[]{0.0f, 0.0f, 0.0f};
        }
        this.offset[0] = value[0];
        this.offset[1] = value[1];
        this.offset[2] = value[2];
        return this;
    }

    protected RenderObjectVbo color(int color) {
        this.color = color;
        return this;
    }

    protected void upload() throws RuntimeException {
        this.upload(false);
    }

    protected void upload(boolean shouldResort) throws RuntimeException {
        block7: {
            this.ensureSafeNoShader();
            this.ensureBuilding(this.builder);
            try (class_9801 meshData = this.builder.method_60794();){
                if (meshData != null) {
                    this.upload(meshData, shouldResort);
                    break block7;
                }
                throw new RuntimeException("Empty Mesh Data!");
            }
        }
    }

    protected void upload(class_287 builder) throws RuntimeException {
        this.upload(builder, false);
    }

    protected void upload(class_287 builder, boolean shouldResort) throws RuntimeException {
        block7: {
            this.ensureSafeNoShader();
            this.ensureBuilding(builder);
            this.builder = builder;
            try (class_9801 meshData = this.builder.method_60794();){
                if (meshData != null) {
                    this.upload(meshData, shouldResort);
                    break block7;
                }
                throw new RuntimeException("Empty Mesh Data!");
            }
        }
    }

    public void upload(class_9801 meshData, boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoShader();
        if (RenderSystem.isOnRenderThread() && meshData != null) {
            int expectedSize = meshData.method_60818().remaining();
            if (this.vertexBuffer != null) {
                this.vertexBuffer.close();
            }
            if (this.indexBuffer != null) {
                this.indexBuffer.close();
                this.indexBuffer = null;
            }
            if (this.vertexBuffer == null) {
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name.get() + " VertexBuffer", 40, (long)expectedSize);
            } else if (this.vertexBuffer.size() < (long)expectedSize) {
                this.vertexBuffer.close();
                this.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name.get() + " VertexBuffer", 40, (long)expectedSize);
            }
            CommandEncoder encoder = RenderSystem.getDevice().createCommandEncoder();
            if (this.vertexBuffer.isClosed()) {
                throw new RuntimeException("Vertex Buffer is closed!");
            }
            encoder.writeToBuffer(this.vertexBuffer.slice(), meshData.method_60818());
            if (shouldResort && meshData.method_60821() != null) {
                if (this.indexBuffer != null && this.indexBuffer.size() >= (long)meshData.method_60821().remaining()) {
                    if (!this.indexBuffer.isClosed()) {
                        encoder.writeToBuffer(this.indexBuffer.slice(), meshData.method_60821());
                    }
                } else {
                    if (this.indexBuffer != null) {
                        this.indexBuffer.close();
                    }
                    this.indexBuffer = RenderSystem.getDevice().createBuffer(() -> this.name.get() + " IndexBuffer", 72, meshData.method_60821());
                }
            } else if (this.indexBuffer != null) {
                this.indexBuffer.close();
                this.indexBuffer = null;
            }
            this.indexCount = meshData.method_60822().comp_751();
            this.indexType = meshData.method_60822().comp_753();
            this.uploaded = true;
        }
    }

    protected class_8251 createVertexSorter(float x, float y, float z) {
        return class_8251.method_49906((float)x, (float)y, (float)z);
    }

    public class_8251 createVertexSorter(class_243 pos) {
        return this.createVertexSorter(pos, class_2338.field_10980);
    }

    protected class_8251 createVertexSorter(class_4184 camera) {
        return this.createVertexSorter(camera.method_71156(), class_2338.field_10980);
    }

    protected class_8251 createVertexSorter(class_4184 camera, class_2338 origin) {
        return this.createVertexSorter(camera.method_71156(), origin);
    }

    protected class_8251 createVertexSorter(class_243 pos, class_2338 origin) {
        return class_8251.method_49906((float)((float)(pos.field_1352 - (double)origin.method_10263())), (float)((float)(pos.field_1351 - (double)origin.method_10264())), (float)((float)(pos.field_1350 - (double)origin.method_10260())));
    }

    public void startResorting(@Nonnull class_9801 meshData, @Nonnull class_8251 sorter) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            this.sortState = meshData.method_60819(this.alloc, sorter);
            this.resortTranslucent(sorter);
        }
    }

    protected boolean shouldResort() {
        return this.sortState != null;
    }

    protected void resortTranslucent(@Nonnull class_8251 sorter) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            if (this.sortState == null) {
                throw new RuntimeException("Sort State is empty!");
            }
            class_9799.class_9800 result = this.sortState.method_60824(this.alloc, sorter);
            if (result != null) {
                this.uploadIndex(result);
                result.close();
            } else {
                throw new RuntimeException("Unable to Store Sorting Data in Result Buffer!");
            }
        }
    }

    protected void uploadIndex(@Nonnull class_9799.class_9800 buffer) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            GpuDevice device = RenderSystem.tryGetDevice();
            if (device == null) {
                MaLiLib.LOGGER.warn("RenderContext#uploadIndex: GpuDevice is null for renderer '{}'", (Object)this.name.get());
                return;
            }
            if (this.indexBuffer == null) {
                this.indexBuffer = device.createBuffer(() -> this.name.get() + " IndexBuffer", 72, buffer.method_60817());
            } else if (!this.indexBuffer.isClosed()) {
                device.createCommandEncoder().writeToBuffer(this.indexBuffer.slice(), buffer.method_60817());
            } else {
                throw new RuntimeException("Index Buffer is closed!");
            }
        }
    }

    protected void bindTexture(class_2960 id, int textureId, int width, int height) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (textureId < 0 || textureId > 12) {
            throw new RuntimeException("Invalid textureId of: " + textureId + " for texture: " + id.toString());
        }
        try {
            while (!this.isTextureValid(textureId, width, height)) {
                this.textures.put(textureId, (class_1049)RenderUtils.tex().method_4619(id));
                if (!this.isTextureValid(textureId, width, height)) continue;
                break;
            }
        }
        catch (Exception err) {
            throw new RuntimeException("Exception reading Texture [" + id.toString() + "]: " + err.getMessage());
        }
        if (this.textures.containsKey(textureId)) {
            return;
        }
        MiniHUD.LOGGER.error("bindTexture: Error uploading texture [{}]", (Object)id.toString());
        if (this.textures.containsKey(textureId)) {
            try (class_1049 tex = this.textures.remove(textureId);){
                tex.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isTextureValid(int textureId, int width, int height) {
        if (this.textures.isEmpty()) return false;
        if (!this.textures.containsKey(textureId)) {
            return false;
        }
        class_1049 tex = this.textures.get(textureId);
        try (class_10539 content = tex.method_65809(RenderUtils.mc().method_1478());){
            class_1011 image = content.comp_3447();
            if (image == null || image.method_4307() != width || image.method_4323() != height) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            this.textures.remove(textureId).close();
            return false;
        }
        if (((IMixinAbstractTexture)tex).malilib_getGlTextureView() != null) {
            if (!tex.method_71659().isClosed()) return true;
        }
        this.textures.remove(textureId).close();
        return false;
    }

    protected void unbindTexture(@Nullable class_2960 id) {
        if (id != null) {
            RenderUtils.tex().method_4615(id);
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Integer key : this.textures.keySet()) {
            if (!this.textures.get(key).method_65859().equals((Object)id)) continue;
            list.add(key);
        }
        for (Integer key : list) {
            try {
                class_1049 tex = this.textures.remove(key);
                try {
                    RenderUtils.tex().method_4615(tex.method_65859());
                    tex.close();
                }
                finally {
                    if (tex == null) continue;
                    tex.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected void draw() throws RuntimeException {
        this.draw(false);
    }

    protected void draw(boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.ensureBuilding(this.builder);
        class_9801 meshData = this.builder.method_60794();
        if (meshData != null) {
            this.draw(meshData, shouldResort);
            meshData.close();
        }
    }

    protected void draw(class_9801 meshData) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, false, false, false);
    }

    protected void draw(class_9801 meshData, boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, shouldResort, false, false);
    }

    protected void draw(class_9801 meshData, boolean shouldResort, boolean setColor) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, shouldResort, setColor, false);
    }

    protected void draw(class_9801 meshData, boolean shouldResort, boolean setColor, boolean useOffset) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(null, meshData, shouldResort, setColor, useOffset);
    }

    protected void draw(@Nullable class_276 otherFb, class_9801 meshData, boolean shouldResort) throws RuntimeException {
        this.ensureSafeNoBuffer();
        this.draw(otherFb, meshData, shouldResort, false, false);
    }

    protected void draw(@Nullable class_276 otherFb, class_9801 meshData, boolean shouldResort, boolean setColor, boolean useOffset) throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (RenderSystem.isOnRenderThread()) {
            if (meshData == null) {
                this.indexCount = 0;
            } else if (this.indexCount < 1) {
                this.upload(meshData, shouldResort);
            }
            if (this.indexCount > 0) {
                float[] rgba = new float[]{class_9848.method_65101((int)this.color), class_9848.method_65102((int)this.color), class_9848.method_65103((int)this.color), class_9848.method_65100((int)this.color)};
                this.drawInternal(otherFb, rgba, setColor, useOffset);
            }
        }
    }

    protected void drawPost() throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(null, false, false);
    }

    protected void drawPost(boolean setColor) throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(null, setColor, false);
    }

    protected void drawPost(@Nullable class_276 otherFb) throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(otherFb, false, false);
    }

    protected void drawPost(@Nullable class_276 otherFb, boolean setColor) throws RuntimeException {
        this.ensureSafeNoTexture();
        this.drawPost(otherFb, setColor, false);
    }

    protected void drawPost(@Nullable class_276 otherFb, boolean setColor, boolean useOffset) throws RuntimeException {
        this.ensureSafeNoTexture();
        if (this.indexCount > 0) {
            float[] rgba = new float[]{class_9848.method_65101((int)this.color), class_9848.method_65102((int)this.color), class_9848.method_65103((int)this.color), class_9848.method_65100((int)this.color)};
            this.drawInternal(otherFb, rgba, setColor, useOffset);
        }
    }

    private void drawInternal(@Nullable class_276 otherFb, float[] rgba, boolean setColor, boolean useOffset) throws RuntimeException {
        this.ensureSafeNoTexture();
        if (RenderSystem.isOnRenderThread()) {
            GpuTextureView texture2;
            GpuTextureView texture1;
            GpuDevice device;
            Vector4f colorMod = new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
            Vector3f modelOffset = new Vector3f();
            Matrix4f texMatrix = new Matrix4f();
            float line = 0.0f;
            if (setColor) {
                colorMod.set(rgba);
            }
            if (useOffset) {
                modelOffset.set(this.offset);
            }
            if ((device = RenderSystem.getDevice()) == null) {
                MiniHUD.LOGGER.warn("RenderContext#drawInternal: GpuDevice is null for renderer '{}'", (Object)this.name.get());
                return;
            }
            class_276 mainFb = RenderUtils.fb();
            if (otherFb != null) {
                texture1 = otherFb.method_71639();
                texture2 = otherFb.field_1478 ? otherFb.method_71640() : null;
            } else {
                texture1 = mainFb.method_71639();
                texture2 = mainFb.field_1478 ? mainFb.method_71640() : null;
            }
            GpuBuffer indexBuffer = this.shapeIndex.method_68274(this.indexCount);
            GpuBufferSlice gpuSlice = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)colorMod, (Vector3fc)modelOffset, (Matrix4fc)texMatrix);
            try (RenderPass pass = device.createCommandEncoder().createRenderPass(this.name, texture1, OptionalInt.empty(), texture2, OptionalDouble.empty());){
                pass.setPipeline(this.shader);
                class_11219 scissorState = RenderSystem.getScissorStateForRenderTypeDraws();
                if (scissorState.method_72091()) {
                    pass.enableScissor(scissorState.method_72092(), scissorState.method_72093(), scissorState.method_72094(), scissorState.method_72095());
                }
                RenderSystem.bindDefaultUniforms((RenderPass)pass);
                pass.setUniform("DynamicTransforms", gpuSlice);
                if (this.indexBuffer == null) {
                    pass.setIndexBuffer(indexBuffer, this.shapeIndex.method_31924());
                } else {
                    pass.setIndexBuffer(this.indexBuffer, this.indexType);
                }
                pass.setVertexBuffer(0, this.vertexBuffer);
                if (!this.textures.isEmpty()) {
                    for (int i = 0; i < this.textures.size(); ++i) {
                        class_1049 tex;
                        if (!this.textures.containsKey(i) || (tex = this.textures.get(i)) == null) continue;
                        pass.bindTexture("Sampler" + i, tex.method_71659(), tex.method_75484());
                    }
                }
                pass.drawIndexed(0, 0, this.indexCount, 1);
            }
        }
    }

    private void ensureBuilding(class_287 builder) throws RuntimeException {
        if (!((IMixinBufferBuilder)builder).malilib_isBuilding()) {
            throw new RuntimeException("Buffer Builder is not building!");
        }
        if (((IMixinBufferBuilder)builder).malilib_getVertexCount() == 0) {
            throw new RuntimeException("Buffer Builder vertices are zero!");
        }
        if (((IMixinBufferBuilder)builder).malilib_getVertexPointer() == -1L) {
            throw new RuntimeException("Buffer Builder has no vertices!");
        }
    }

    private void ensureSafeNoShader() throws RuntimeException {
        if (!this.started) {
            throw new RuntimeException("Context not started!");
        }
        if (this.alloc == null) {
            throw new RuntimeException("Allocator not valid!");
        }
        if (this.builder == null) {
            throw new RuntimeException("Buffer Builder not valid!");
        }
        if (this.name.get().isEmpty()) {
            this.name = () -> "RenderObjectVbo";
        }
    }

    private void ensureSafeNoBuffer() throws RuntimeException {
        this.ensureSafeNoShader();
        if (this.shader == null) {
            throw new RuntimeException("Shader Pipeline not valid!");
        }
    }

    private void ensureSafeNoTexture() throws RuntimeException {
        this.ensureSafeNoBuffer();
        if (this.vertexBuffer == null) {
            throw new RuntimeException("GpuBuffer not uploaded!");
        }
    }

    private void ensureSafe() {
        this.ensureSafeNoTexture();
        if (this.textures.isEmpty()) {
            throw new RuntimeException("A Texture Object is expected to be bound");
        }
    }

    protected void reset() {
        if (this.vertexBuffer != null) {
            this.vertexBuffer.close();
            this.vertexBuffer = null;
        }
        if (this.indexBuffer != null) {
            this.indexBuffer.close();
            this.indexBuffer = null;
        }
        if (this.sortState != null) {
            this.sortState = null;
        }
        if (this.builder != null) {
            if (((IMixinBufferBuilder)this.builder).malilib_isBuilding() && ((IMixinBufferBuilder)this.builder).malilib_getVertexCount() != 0) {
                try {
                    class_9801 meshData = this.builder.method_60794();
                    if (meshData != null) {
                        meshData.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.builder = null;
        }
        if (this.alloc != null) {
            this.alloc.close();
            this.alloc = null;
        }
        this.indexCount = -1;
        this.indexType = null;
        this.offset = new float[]{0.0f, 0.0f, 0.0f};
        this.color = -1;
        this.started = false;
        this.uploaded = false;
    }

    protected void close() {
        if (!this.textures.isEmpty()) {
            for (class_1049 tex : this.textures.values()) {
                RenderUtils.tex().method_4615(tex.method_65859());
                tex.close();
            }
            this.textures.clear();
        }
        this.reset();
    }
}

