/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.renderer;

import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.malilib.render.MaLiLibPipelines;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.data.Color4f;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.block.IMixinBeaconBlockEntity;
import fi.dy.masa.minihud.renderer.BaseBlockRangeOverlay;
import fi.dy.masa.minihud.renderer.RenderObjectVbo;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_10633;
import net.minecraft.class_1291;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2580;
import net.minecraft.class_2591;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_3695;
import net.minecraft.class_6880;
import net.minecraft.class_9801;

public class OverlayRendererBeaconRange
extends BaseBlockRangeOverlay<class_2580> {
    public static final OverlayRendererBeaconRange INSTANCE = new OverlayRendererBeaconRange();
    private final HashMap<class_2338, Integer> positions;

    public OverlayRendererBeaconRange() {
        super((IConfigBoolean)RendererToggle.OVERLAY_BEACON_RANGE, class_2591.field_11890, class_2580.class);
        this.useCulling = false;
        this.positions = new HashMap();
    }

    @Override
    public String getName() {
        return "BeaconRange";
    }

    @Override
    protected void updateBlockRange(class_1937 world, class_2338 pos, class_2580 be, class_243 cameraPos, class_310 mc, class_3695 profiler) {
        List<class_10633.class_2581> segments = ((IMixinBeaconBlockEntity)be).minihud_getBeamEmitter();
        class_6880<class_1291> primary = ((IMixinBeaconBlockEntity)be).minihud_getPrimary();
        int level = ((IMixinBeaconBlockEntity)be).minihud_getLevel();
        if (segments.isEmpty() || level == 0) {
            this.positions.remove(pos);
        } else if (level >= 1 && level <= 4 && primary != null) {
            this.positions.put(pos, level);
        } else {
            this.positions.remove(pos);
        }
    }

    @Override
    protected void renderBlockRange(class_1937 world, class_243 cameraPos, class_310 mc, class_3695 profiler) {
        this.renderThrough = false;
        if (!this.positions.isEmpty()) {
            this.allocateBuffers(true);
            this.renderQuads(world, cameraPos, mc, profiler);
            this.renderOutlines(world, cameraPos, mc, profiler);
        } else {
            this.clearBuffers();
        }
    }

    @Override
    protected void resetBlockRange() {
        this.positions.clear();
    }

    private void renderQuads(class_1937 world, class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        double camX = cameraPos.field_1352;
        double camY = cameraPos.field_1351;
        double camZ = cameraPos.field_1350;
        profiler.method_15396("beacon_quads");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.getFirst();
        class_287 builder = ctx.start(() -> "minihud:beacon/quads", this.renderThrough ? MaLiLibPipelines.POSITION_COLOR_MASA_NO_DEPTH_NO_CULL : MaLiLibPipelines.POSITION_COLOR_MASA_LEQUAL_DEPTH_OFFSET_1);
        this.positions.forEach((pos, level) -> {
            double x = (double)pos.method_10263() - camX;
            double y = (double)pos.method_10264() - camY;
            double z = (double)pos.method_10260() - camZ;
            Color4f color = OverlayRendererBeaconRange.getColorForLevel(level);
            int range = level * 10 + 10;
            double minX = x - (double)range;
            double minY = y - (double)range;
            double minZ = z - (double)range;
            double maxX = x + (double)range + 1.0;
            double maxY = this.getTopYOverTerrain(world, (class_2338)pos, range);
            double maxZ = z + (double)range + 1.0;
            RenderUtils.drawBoxAllSidesBatchedQuads((float)((float)minX), (float)((float)minY), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (Color4f)color, (class_287)builder);
        });
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, this.shouldResort);
                if (this.shouldResort) {
                    ctx.startResorting(meshData, ctx.createVertexSorter(cameraPos));
                }
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererBeaconRange#renderQuads(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    private void renderOutlines(class_1937 world, class_243 cameraPos, class_310 mc, class_3695 profiler) {
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        double camX = cameraPos.field_1352;
        double camY = cameraPos.field_1351;
        double camZ = cameraPos.field_1350;
        profiler.method_15396("beacon_outlines");
        RenderObjectVbo ctx = (RenderObjectVbo)this.renderObjects.get(1);
        class_287 builder = ctx.start(() -> "minihud:beacon/outlines", MaLiLibPipelines.DEBUG_LINES_MASA_SIMPLE_LEQUAL_DEPTH);
        this.positions.forEach((pos, level) -> {
            double x = (double)pos.method_10263() - camX;
            double y = (double)pos.method_10264() - camY;
            double z = (double)pos.method_10260() - camZ;
            Color4f color = OverlayRendererBeaconRange.getColorForLevel(level);
            int range = level * 10 + 10;
            double minX = x - (double)range;
            double minY = y - (double)range;
            double minZ = z - (double)range;
            double maxX = x + (double)range + 1.0;
            double maxY = this.getTopYOverTerrain(world, (class_2338)pos, range);
            double maxZ = z + (double)range + 1.0;
            RenderUtils.drawBoxAllEdgesBatchedLines((float)((float)minX), (float)((float)minY), (float)((float)minZ), (float)((float)maxX), (float)((float)maxY), (float)((float)maxZ), (Color4f)Color4f.fromColor((int)color.intValue, (float)1.0f), (float)this.glLineWidth, (class_287)builder);
        });
        try {
            class_9801 meshData = builder.method_60794();
            if (meshData != null) {
                ctx.upload(meshData, false);
                meshData.close();
            }
        }
        catch (Exception err) {
            MiniHUD.LOGGER.error("OverlayRendererBeaconRange#renderOutlines(): Exception; {}", (Object)err.getMessage());
        }
        profiler.method_15407();
    }

    public static Color4f getColorForLevel(int level) {
        return switch (level) {
            case 1 -> Configs.Colors.BEACON_RANGE_LVL1_OVERLAY_COLOR.getColor();
            case 2 -> Configs.Colors.BEACON_RANGE_LVL2_OVERLAY_COLOR.getColor();
            case 3 -> Configs.Colors.BEACON_RANGE_LVL3_OVERLAY_COLOR.getColor();
            default -> Configs.Colors.BEACON_RANGE_LVL4_OVERLAY_COLOR.getColor();
        };
    }
}

