/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.generic;

import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.info.InfoLine;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class InfoLineServux
extends InfoLine {
    private static final String SERVUX_KEY = "minihud.info_line.servux";
    private static final String YES_KEY = "minihud.info_line.slime_chunk.yes";
    private static final String NO_KEY = "minihud.info_line.slime_chunk.no";

    public InfoLineServux(InfoToggle type) {
        super(type);
    }

    public InfoLineServux() {
        this(InfoToggle.SERVUX);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (!this.getData().hasIntegratedServer()) {
            if (this.getEntData().hasServuxServer()) {
                list.add(this.translate(SERVUX_KEY, this.getEntData().getServuxVersion()));
            } else if (this.getData().hasServuxServer()) {
                list.add(this.translate(SERVUX_KEY, this.getData().getServuxVersion()));
            } else if (this.getHudData().hasServuxServer()) {
                list.add(this.translate(SERVUX_KEY, this.getHudData().getServuxVersion()));
            }
            if (!Configs.Generic.HUD_DATA_SYNC.getBooleanValue()) {
                list.add(this.translate("minihud.info_line.servux.hud_sync.not_enabled", new Object[0]));
            } else if (!this.getHudData().hasServuxServer()) {
                list.add(this.translate("minihud.info_line.servux.hud_sync.not_connected", new Object[0]));
            } else if (this.getHudData().hasServuxServer()) {
                list.add(this.translate("minihud.info_line.servux.hud_sync", this.getHudData().getWorldSpawnAsString(), this.getHudData().isWorldSpawnKnown() ? this.qt(YES_KEY, new Object[0]) : this.qt(NO_KEY, new Object[0])));
            }
            if (!Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue() && !Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue()) {
                list.add(this.translate("minihud.info_line.servux.entity_sync.not_enabled", new Object[0]));
            } else if (Configs.Generic.ENTITY_DATA_SYNC.getBooleanValue() && !this.getHudData().hasServuxServer()) {
                list.add(this.translate("minihud.info_line.servux.entity_sync.not_connected", new Object[0]));
            } else if (this.getEntData().hasServuxServer()) {
                list.add(this.translate("minihud.info_line.servux.entity_sync", this.getEntData().getBlockEntityCacheCount(), this.getEntData().getPendingBlockEntitiesCount(), this.getEntData().getEntityCacheCount(), this.getEntData().getPendingEntitiesCount()));
            } else if (this.getEntData().hasBackupStatus()) {
                list.add(this.translate("minihud.info_line.servux.entity_sync.backup", this.getEntData().getBlockEntityCacheCount(), this.getEntData().getPendingBlockEntitiesCount(), this.getEntData().getEntityCacheCount(), this.getEntData().getPendingEntitiesCount()));
            } else if (Configs.Generic.ENTITY_DATA_SYNC_BACKUP.getBooleanValue() && !this.getEntData().hasOperatorStatus()) {
                list.add(this.translate("minihud.info_line.servux.entity_sync.not_operator", new Object[0]));
            }
            if (!RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                list.add(this.translate("minihud.info_line.servux.structures.not_enabled", new Object[0]));
            } else if (!this.getData().hasServuxServer()) {
                list.add(this.translate("minihud.info_line.servux.structures.not_connected", new Object[0]));
            } else if (this.getData().hasServuxServer()) {
                list.add(this.translate("minihud.info_line.servux.structures.servux", this.getData().getStrucutreCount(), this.getData().getStructureDataMaxRange(), this.getData().getServerRenderDistance()));
            }
        } else if (this.getData().hasIntegratedServer()) {
            list.add(this.translate("minihud.info_line.servux.hud_sync.integrated", this.getHudData().getWorldSpawnAsString(), this.getHudData().isWorldSpawnKnown() ? this.qt(YES_KEY, new Object[0]) : this.qt(NO_KEY, new Object[0])));
            if (RendererToggle.OVERLAY_STRUCTURE_MAIN_TOGGLE.getBooleanValue()) {
                list.add(this.translate("minihud.info_line.servux.structures.integrated", this.getData().getStrucutreCount(), this.getData().getStructureDataMaxRange(), this.getData().getServerRenderDistance()));
            }
        }
        return list;
    }
}

