/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.entity;

import fi.dy.masa.malilib.util.data.DataEntityUtils;
import fi.dy.masa.malilib.util.data.tag.CompoundData;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.util.MiscUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_5455;
import net.minecraft.class_6880;

public class InfoLineLookingAtEffects
extends InfoLine {
    private static final String EFFECTS_KEY = "minihud.info_line.looking_at_effects";

    public InfoLineLookingAtEffects(InfoToggle type) {
        super(type);
    }

    public InfoLineLookingAtEffects() {
        this(InfoToggle.LOOKING_AT_EFFECTS);
    }

    @Override
    public boolean succeededType() {
        return false;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        if (ctx.hasLiving() && ctx.hasData()) {
            class_1299 entityType = DataEntityUtils.getEntityType((CompoundData)ctx.data());
            if (entityType == null) {
                return null;
            }
            return this.parseData(ctx.world(), entityType, ctx.data());
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseData(@Nonnull class_1937 world, @Nonnull class_1299<?> entityType, @Nonnull CompoundData data) {
        Map effects = DataEntityUtils.getActiveStatusEffects((CompoundData)data, (class_5455)world.method_30349());
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (effects == null || effects.isEmpty()) {
            return list;
        }
        for (class_6880 effectType : effects.keySet()) {
            class_1293 effect = (class_1293)effects.get(effectType);
            if (!effect.method_48559() && effect.method_5584() <= 0) continue;
            list.add(this.translate(EFFECTS_KEY, ((class_1291)effectType.comp_349()).method_5560().getString(), effect.method_5578() > 0 ? this.qt("minihud.info_line.looking_at_effects.amplifier", effect.method_5578() + 1) : "", effect.method_48559() ? this.qt("minihud.info_line.looking_at_effects.infinite", new Object[0]) : MiscUtils.formatDuration((long)(effect.method_5584() / 20) * 1000L), this.qt("minihud.info_line.remaining", new Object[0])));
        }
        return list;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@Nonnull class_1937 world, @Nonnull class_1297 ent) {
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        if (ent instanceof class_1309) {
            class_1309 living = (class_1309)ent;
            Collection effects = living.method_6026();
            for (class_1293 effect : effects) {
                if (!effect.method_48559() && effect.method_5584() <= 0) continue;
                list.add(this.translate(EFFECTS_KEY, ((class_1291)effect.method_5579().comp_349()).method_5560().getString(), effect.method_5578() > 0 ? this.qt("minihud.info_line.looking_at_effects.amplifier", effect.method_5578() + 1) : "", effect.method_48559() ? this.qt("minihud.info_line.looking_at_effects.infinite", new Object[0]) : MiscUtils.formatDuration((long)(effect.method_5584() / 20) * 1000L), this.qt("minihud.info_line.remaining", new Object[0])));
            }
        }
        return list;
    }
}

