/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.info.camera;

import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.InfoToggle;
import fi.dy.masa.minihud.info.InfoLine;
import fi.dy.masa.minihud.util.SpeedUnits;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_3532;

public class InfoLineRotationYaw
extends InfoLine {
    private static final String SPEED_KEY = "minihud.info_line.speed_";
    private static final String ROT_YAW_KEY = "minihud.info_line.rotation_yaw";
    private static final String ROT_PITCH_KEY = "minihud.info_line.rotation_pitch";

    public InfoLineRotationYaw(InfoToggle type) {
        super(type);
    }

    public InfoLineRotationYaw() {
        this(InfoToggle.ROTATION_YAW);
    }

    @Override
    public boolean succeededType() {
        return this.succeeded;
    }

    @Override
    public List<InfoLine.Entry> parse(@Nonnull InfoLine.Context ctx) {
        if (ctx.world() == null) {
            return null;
        }
        return ctx.ent() != null ? this.parseEnt(ctx.world(), ctx.ent()) : null;
    }

    @Override
    public List<InfoLine.Entry> parseEnt(@Nonnull class_1937 world, @Nonnull class_1297 ent) {
        SpeedUnits speedUnits = (SpeedUnits)Configs.Generic.SPEED_UNITS.getOptionListValue();
        ArrayList<InfoLine.Entry> list = new ArrayList<InfoLine.Entry>();
        String pre = "";
        StringBuilder str = new StringBuilder(128);
        if (InfoToggle.ROTATION_YAW.getBooleanValue()) {
            str.append(this.qt(ROT_YAW_KEY, Float.valueOf(class_3532.method_15393((float)ent.method_36454()))));
            pre = " / ";
        }
        if (InfoToggle.ROTATION_PITCH.getBooleanValue()) {
            str.append(pre).append(this.qt(ROT_PITCH_KEY, Float.valueOf(class_3532.method_15393((float)ent.method_36455()))));
            pre = " / ";
        }
        if (InfoToggle.SPEED.getBooleanValue()) {
            double dx = ent.method_23317() - ent.field_6038;
            double dy = ent.method_23318() - ent.field_5971;
            double dz = ent.method_23321() - ent.field_5989;
            double dist = Math.sqrt(dx * dx + dy * dy + dz * dz);
            str.append(pre).append(this.qt(SPEED_KEY + speedUnits.suffix, speedUnits.convert(dist * 20.0)));
        }
        list.add(this.of(str.toString()));
        this.succeeded = true;
        return list;
    }
}

