/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.gui.widgets;

import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.button.ButtonBase;
import fi.dy.masa.malilib.gui.button.ButtonGeneric;
import fi.dy.masa.malilib.gui.button.ButtonOnOff;
import fi.dy.masa.malilib.gui.button.IButtonActionListener;
import fi.dy.masa.malilib.gui.widgets.WidgetListEntryBase;
import fi.dy.masa.malilib.render.GuiContext;
import fi.dy.masa.malilib.render.RenderUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.gui.GuiShapeEditor;
import fi.dy.masa.minihud.gui.widgets.WidgetListShapes;
import fi.dy.masa.minihud.renderer.shapes.ShapeBase;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import java.util.List;
import net.minecraft.class_11909;
import net.minecraft.class_437;

public class WidgetShapeEntry
extends WidgetListEntryBase<ShapeBase> {
    private final WidgetListShapes parent;
    private final ShapeBase shape;
    private final List<String> hoverLines;
    private final boolean isOdd;
    private final int buttonsStartX;

    public WidgetShapeEntry(int x, int y, int width, int height, boolean isOdd, ShapeBase shape, int listIndex, WidgetListShapes parent) {
        super(x, y, width, height, (Object)shape, listIndex);
        this.shape = shape;
        this.hoverLines = shape.getWidgetHoverLines();
        this.isOdd = isOdd;
        this.parent = parent;
        int posX = x + width - 2;
        posX -= this.addButton(posX, ++y, ButtonListener.Type.REMOVE);
        posX -= this.createButtonOnOff(posX, y, this.shape.isEnabled(), ButtonListener.Type.ENABLED);
        posX -= this.addButton(posX, y, ButtonListener.Type.CONFIGURE);
        this.buttonsStartX = posX;
    }

    protected int addButton(int x, int y, ButtonListener.Type type) {
        ButtonGeneric button = new ButtonGeneric(x, y, -1, true, type.getDisplayName(new Object[0]), new Object[0]);
        this.addButton((ButtonBase)button, new ButtonListener(type, this));
        return button.getWidth() + 1;
    }

    private int createButtonOnOff(int xRight, int y, boolean isCurrentlyOn, ButtonListener.Type type) {
        ButtonOnOff button = new ButtonOnOff(xRight, y, -1, true, type.getTranslationKey(), isCurrentlyOn, new String[0]);
        this.addButton((ButtonBase)button, new ButtonListener(type, this));
        return button.getWidth() + 2;
    }

    public boolean canSelectAt(class_11909 click) {
        return super.canSelectAt(click) && click.comp_4798() < (double)this.buttonsStartX;
    }

    public void render(GuiContext ctx, int mouseX, int mouseY, boolean selected) {
        boolean shapeSelected;
        boolean bl = shapeSelected = ShapeManager.INSTANCE.getSelectedShape() == this.entry;
        if (selected || shapeSelected || this.isMouseOver(mouseX, mouseY)) {
            RenderUtils.drawRect((GuiContext)ctx, (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x70FFFFFF);
        } else if (this.isOdd) {
            RenderUtils.drawRect((GuiContext)ctx, (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x20FFFFFF);
        } else {
            RenderUtils.drawRect((GuiContext)ctx, (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)0x50FFFFFF);
        }
        if (shapeSelected) {
            RenderUtils.drawOutline((GuiContext)ctx, (int)this.x, (int)this.y, (int)this.width, (int)this.height, (int)-2039584);
        }
        String name = this.shape.getDisplayName();
        this.drawString(ctx, this.x + 4, this.y + 7, -1, name);
        super.render(ctx, mouseX, mouseY, selected);
    }

    public void postRenderHovered(GuiContext ctx, int mouseX, int mouseY, boolean selected) {
        super.postRenderHovered(ctx, mouseX, mouseY, selected);
        if (mouseX >= this.x && mouseX < this.buttonsStartX && mouseY >= this.y && mouseY <= this.y + this.height) {
            RenderUtils.drawHoverText((GuiContext)ctx, (int)mouseX, (int)mouseY, this.hoverLines);
        }
    }

    private record ButtonListener(Type type, WidgetShapeEntry widget) implements IButtonActionListener
    {
        public void actionPerformedWithButton(ButtonBase button, int mouseButton) {
            if (this.type == Type.CONFIGURE) {
                GuiShapeEditor gui = new GuiShapeEditor(this.widget.shape);
                gui.setParent(GuiUtils.getCurrentScreen());
                GuiBase.openGui((class_437)gui);
            } else if (this.type == Type.ENABLED) {
                this.widget.shape.toggleEnabled();
                this.widget.parent.refreshEntries();
            } else if (this.type == Type.REMOVE) {
                ShapeManager.INSTANCE.removeShape(this.widget.shape);
                this.widget.parent.refreshEntries();
            }
        }

        public static enum Type {
            CONFIGURE("minihud.gui.button.configure"),
            ENABLED("minihud.gui.button.shape_entry.enabled"),
            REMOVE("minihud.gui.button.remove");

            private final String translationKey;

            private Type(String translationKey) {
                this.translationKey = translationKey;
            }

            public String getTranslationKey() {
                return this.translationKey;
            }

            public String getDisplayName(Object ... args) {
                return StringUtils.translate((String)this.translationKey, (Object[])args);
            }
        }
    }
}

