/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import fi.dy.masa.malilib.MaLiLib;
import fi.dy.masa.malilib.gui.GuiBase;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.gui.interfaces.IDirectoryNavigator;
import fi.dy.masa.malilib.interfaces.IStringConsumerFeedback;
import fi.dy.masa.malilib.util.FileNameUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.annotation.Nullable;

public record FileRenamer(Path file, @Nullable IDirectoryNavigator navigator, boolean feedback) implements IStringConsumerFeedback
{
    @Override
    public boolean setString(String string) {
        if (string.isEmpty() || this.file() == null) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.invalid_file_or_directory", new Object[0]);
            MaLiLib.debugLog("FileRenamer: Failed to rename file; File is invalid/empty.", new Object[0]);
            return false;
        }
        Path dir = this.file().getParent();
        Path newFile = dir.resolve(FileNameUtils.generateSafeFileName(string)).normalize();
        if (this.file().getFileName().equals(newFile.getFileName())) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.file_rename.same_name", newFile.toAbsolutePath());
            MaLiLib.debugLog("FileRenamer: Failed to rename file '{}'; Destination is the same.", this.file().toAbsolutePath());
            return true;
        }
        if (!Files.exists(this.file(), new LinkOption[0])) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.file_or_directory_does_not_exist", this.file().toAbsolutePath());
            MaLiLib.debugLog("FileRenamer: Failed to rename file '{}'; Source does not exist.", this.file().toAbsolutePath());
            return false;
        }
        if (Files.exists(newFile, new LinkOption[0])) {
            if (GuiBase.isShiftDown()) {
                try {
                    Files.delete(newFile);
                }
                catch (Exception err) {
                    InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.error.failed_to_delete_file", this.file().toAbsolutePath());
                    MaLiLib.debugLog("FileRenamer: Failed to delete file '{}'; {}", this.file().toAbsolutePath(), err.getLocalizedMessage());
                    return false;
                }
            } else {
                InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_rename_file.exists", this.file().toAbsolutePath(), newFile.toAbsolutePath());
                MaLiLib.debugLog("FileRenamer: Failed to rename file '{}'; Destination file exists.", this.file().toAbsolutePath());
                return false;
            }
        }
        try {
            Files.move(this.file(), newFile, new CopyOption[0]);
        }
        catch (Exception err) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.ERROR, "malilib.message.error.failed_to_rename_file.exception", this.file().toAbsolutePath(), newFile.toAbsolutePath(), err.getLocalizedMessage());
            MaLiLib.debugLog("FileRenamer: Exception renaming file '{}'; {}", this.file().toAbsolutePath(), err.getLocalizedMessage());
            return false;
        }
        if (this.feedback()) {
            InfoUtils.showGuiOrActionBarMessage(Message.MessageType.SUCCESS, "malilib.message.file_or_directory_renamed", newFile.getFileName());
        }
        MaLiLib.debugLog("FileRenamer: Renamed file '{}' -> '{}'", this.file().toAbsolutePath(), newFile.toAbsolutePath());
        return true;
    }
}

