/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.texture;

import java.util.Map;
import net.caffeinemc.mods.sodium.client.model.quad.ModelQuadView;
import net.caffeinemc.mods.sodium.client.render.texture.SodiumSpriteFinder;
import net.minecraft.class_1058;
import net.minecraft.class_2960;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodiumSpriteFinderImpl
implements SodiumSpriteFinder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SodiumSpriteFinderImpl.class);
    private final Node root = new Node(0.5f, 0.5f, 0.25f);
    private final class_1058 missingSprite;
    private int badSpriteCount = 0;

    public SodiumSpriteFinderImpl(Map<class_2960, class_1058> sprites, class_1058 missingSprite) {
        this.missingSprite = missingSprite;
        sprites.values().forEach(this.root::add);
    }

    @Override
    public class_1058 find(ModelQuadView quad) {
        float u = 0.0f;
        float v = 0.0f;
        for (int i = 0; i < 4; ++i) {
            u += quad.getTexU(i);
            v += quad.getTexV(i);
        }
        return this.find(u * 0.25f, v * 0.25f);
    }

    @Override
    public class_1058 find(float u, float v) {
        return this.root.find(u, v);
    }

    private class Node {
        final float midU;
        final float midV;
        final float cellRadius;
        @Nullable Object lowLow = null;
        @Nullable Object lowHigh = null;
        @Nullable Object highLow = null;
        @Nullable Object highHigh = null;
        static final float EPS = 1.0E-5f;

        Node(float midU, float midV, float radius) {
            this.midU = midU;
            this.midV = midV;
            this.cellRadius = radius;
        }

        void add(class_1058 sprite) {
            boolean highV;
            if (sprite.method_4594() < -1.0E-5f || sprite.method_4577() > 1.00001f || sprite.method_4593() < -1.0E-5f || sprite.method_4575() > 1.00001f) {
                if (SodiumSpriteFinderImpl.this.badSpriteCount++ < 5) {
                    String errorMessage = "SpriteFinderImpl: Skipping sprite {} with broken bounds [{}, {}]x[{}, {}]. Sprite bounds should be between 0 and 1.";
                    LOGGER.error(errorMessage, new Object[]{sprite.method_45851().method_45816(), Float.valueOf(sprite.method_4594()), Float.valueOf(sprite.method_4577()), Float.valueOf(sprite.method_4593()), Float.valueOf(sprite.method_4575())});
                }
                return;
            }
            boolean lowU = sprite.method_4594() < this.midU - 1.0E-5f;
            boolean highU = sprite.method_4577() > this.midU + 1.0E-5f;
            boolean lowV = sprite.method_4593() < this.midV - 1.0E-5f;
            boolean bl = highV = sprite.method_4575() > this.midV + 1.0E-5f;
            if (lowU && lowV) {
                this.lowLow = this.addInner(sprite, this.lowLow, -1, -1);
            }
            if (lowU && highV) {
                this.lowHigh = this.addInner(sprite, this.lowHigh, -1, 1);
            }
            if (highU && lowV) {
                this.highLow = this.addInner(sprite, this.highLow, 1, -1);
            }
            if (highU && highV) {
                this.highHigh = this.addInner(sprite, this.highHigh, 1, 1);
            }
        }

        private Object addInner(class_1058 sprite, @Nullable Object quadrant, int uStep, int vStep) {
            if (quadrant == null) {
                return sprite;
            }
            if (quadrant instanceof Node) {
                Node node = (Node)quadrant;
                node.add(sprite);
                return quadrant;
            }
            Node n = new Node(this.midU + this.cellRadius * (float)uStep, this.midV + this.cellRadius * (float)vStep, this.cellRadius * 0.5f);
            if (quadrant instanceof class_1058) {
                class_1058 prevSprite = (class_1058)quadrant;
                n.add(prevSprite);
            }
            n.add(sprite);
            return n;
        }

        private class_1058 find(float u, float v) {
            if (u < this.midU) {
                return v < this.midV ? this.findInner(this.lowLow, u, v) : this.findInner(this.lowHigh, u, v);
            }
            return v < this.midV ? this.findInner(this.highLow, u, v) : this.findInner(this.highHigh, u, v);
        }

        private class_1058 findInner(@Nullable Object quadrant, float u, float v) {
            if (quadrant instanceof Node) {
                Node node = (Node)quadrant;
                return node.find(u, v);
            }
            if (quadrant instanceof class_1058) {
                class_1058 sprite = (class_1058)quadrant;
                return sprite;
            }
            return SodiumSpriteFinderImpl.this.missingSprite;
        }
    }
}

