/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.config.builder;

import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.api.config.ConfigState;
import net.caffeinemc.mods.sodium.api.config.StorageEventHandler;
import net.caffeinemc.mods.sodium.api.config.option.OptionBinding;
import net.caffeinemc.mods.sodium.api.config.option.OptionFlag;
import net.caffeinemc.mods.sodium.api.config.option.OptionImpact;
import net.caffeinemc.mods.sodium.api.config.structure.EnumOptionBuilder;
import net.caffeinemc.mods.sodium.client.config.builder.StatefulOptionBuilderImpl;
import net.caffeinemc.mods.sodium.client.config.structure.EnumOption;
import net.caffeinemc.mods.sodium.client.config.value.ConstantValue;
import net.caffeinemc.mods.sodium.client.config.value.DependentValue;
import net.caffeinemc.mods.sodium.client.config.value.DynamicValue;
import net.caffeinemc.mods.sodium.client.gui.options.TextProvider;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.lang3.Validate;

class EnumOptionBuilderImpl<E extends Enum<E>>
extends StatefulOptionBuilderImpl<EnumOption<E>, E>
implements EnumOptionBuilder<E> {
    private final Class<E> enumClass;
    private DependentValue<Set<E>> allowedValues;
    private Function<E, class_2561> elementNameProvider;

    EnumOptionBuilderImpl(class_2960 id, Class<E> enumClass) {
        super(id);
        this.enumClass = enumClass;
    }

    @Override
    void validateData() {
        super.validateData();
        Validate.notNull(this.getElementNameProvider(), (String)"Element name provider must be set or enum class must implement TextProvider", (Object[])new Object[0]);
    }

    @Override
    EnumOption<E> build() {
        if (this.getAllowedValues() == null) {
            this.allowedValues = new ConstantValue<Set<Enum>>(Set.of((Enum[])this.enumClass.getEnumConstants()));
        }
        if (this.getElementNameProvider() == null && TextProvider.class.isAssignableFrom(this.enumClass)) {
            this.elementNameProvider = e -> ((TextProvider)((Object)e)).getLocalizedName();
        }
        this.prepareBuild();
        return new EnumOption(this.id, this.getDependencies(), this.getName(), this.getEnabled(), this.getStorage(), this.getTooltipProvider(), this.getImpact(), this.getFlags(), this.getDefaultValue(), this.getBinding(), this.getEnumClass(), this.getAllowedValues(), this.getElementNameProvider());
    }

    @Override
    Class<EnumOption<E>> getOptionClass() {
        Class<EnumOption> clazz = EnumOption.class;
        return clazz;
    }

    @Override
    Collection<class_2960> getDependencies() {
        Collection<class_2960> deps = super.getDependencies();
        deps.addAll(this.getAllowedValues().getDependencies());
        return deps;
    }

    Class<E> getEnumClass() {
        return this.getFirstNotNull(this.enumClass, EnumOption::getEnumClass);
    }

    DependentValue<Set<E>> getAllowedValues() {
        return this.getFirstNotNull(this.allowedValues, EnumOption::getAllowedValues);
    }

    Function<E, class_2561> getElementNameProvider() {
        return this.getFirstNotNull(this.elementNameProvider, EnumOption::getElementNameProvider);
    }

    @Override
    public EnumOptionBuilder<E> setAllowedValues(Set<E> allowedValues) {
        this.allowedValues = new ConstantValue<Set<E>>(allowedValues);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setAllowedValuesProvider(Function<ConfigState, Set<E>> provider, class_2960 ... dependencies) {
        this.allowedValues = new DynamicValue<Set<E>>(provider, dependencies);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setElementNameProvider(Function<E, class_2561> provider) {
        this.elementNameProvider = provider;
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setName(class_2561 name) {
        super.setName(name);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setStorageHandler(StorageEventHandler storage) {
        super.setStorageHandler(storage);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setTooltip(class_2561 tooltip) {
        super.setTooltip(tooltip);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setTooltip(Function<E, class_2561> tooltip) {
        super.setTooltip(tooltip);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setImpact(OptionImpact impact) {
        super.setImpact(impact);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setFlags(OptionFlag ... flags) {
        super.setFlags(flags);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setDefaultValue(E value) {
        super.setDefaultValue(value);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setDefaultProvider(Function<ConfigState, E> provider, class_2960 ... dependencies) {
        super.setDefaultProvider(provider, dependencies);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setEnabled(boolean available) {
        super.setEnabled(available);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setEnabledProvider(Function<ConfigState, Boolean> provider, class_2960 ... dependencies) {
        super.setEnabledProvider((Function)provider, dependencies);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setBinding(Consumer<E> save, Supplier<E> load) {
        super.setBinding(save, load);
        return this;
    }

    @Override
    public EnumOptionBuilder<E> setBinding(OptionBinding<E> binding) {
        super.setBinding(binding);
        return this;
    }
}

