/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import java.util.function.LongConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3532;

public class RayTracer {
    protected final class_243 start;
    protected final class_243 end;
    protected final int endBlockX;
    protected final int endBlockY;
    protected final int endBlockZ;
    protected double x;
    protected double y;
    protected double z;
    protected int blockX;
    protected int blockY;
    protected int blockZ;
    protected class_2350 side = class_2350.field_11036;

    public RayTracer(class_2338 start, class_2338 end) {
        this(new class_243((double)start.method_10263() + 0.5, (double)start.method_10264() + 0.5, (double)start.method_10260() + 0.5), new class_243((double)end.method_10263() + 0.5, (double)end.method_10264() + 0.5, (double)end.method_10260() + 0.5));
    }

    public RayTracer(class_243 start, class_243 end) {
        this.start = start;
        this.end = end;
        this.x = start.field_1352;
        this.y = start.field_1351;
        this.z = start.field_1350;
        this.endBlockX = class_3532.method_15357((double)end.field_1352);
        this.endBlockY = class_3532.method_15357((double)end.field_1351);
        this.endBlockZ = class_3532.method_15357((double)end.field_1350);
        this.blockX = class_3532.method_15357((double)start.field_1352);
        this.blockY = class_3532.method_15357((double)start.field_1351);
        this.blockZ = class_3532.method_15357((double)start.field_1350);
    }

    public boolean advance() {
        if (Double.isNaN(this.x) || Double.isNaN(this.y) || Double.isNaN(this.z)) {
            return true;
        }
        if (this.blockX == this.endBlockX && this.blockY == this.endBlockY && this.blockZ == this.endBlockZ) {
            return true;
        }
        boolean positiveX = this.endBlockX > this.blockX;
        boolean positiveY = this.endBlockY > this.blockY;
        boolean positiveZ = this.endBlockZ > this.blockZ;
        double distToEndX = this.end.field_1352 - this.x;
        double distToEndY = this.end.field_1351 - this.y;
        double distToEndZ = this.end.field_1350 - this.z;
        double nextX = 999.0;
        double nextY = 999.0;
        double nextZ = 999.0;
        double relStepX = 999.0;
        double relStepY = 999.0;
        double relStepZ = 999.0;
        if (positiveX) {
            nextX = (double)this.blockX + 1.0;
            relStepX = (nextX - this.x) / distToEndX;
        } else if (this.endBlockX < this.blockX) {
            nextX = this.blockX;
            relStepX = (nextX - this.x) / distToEndX;
        }
        if (positiveY) {
            nextY = (double)this.blockY + 1.0;
            relStepY = (nextY - this.y) / distToEndY;
        } else if (this.endBlockY < this.blockY) {
            nextY = this.blockY;
            relStepY = (nextY - this.y) / distToEndY;
        }
        if (positiveZ) {
            nextZ = (double)this.blockZ + 1.0;
            relStepZ = (nextZ - this.z) / distToEndZ;
        } else if (this.endBlockZ < this.blockZ) {
            nextZ = this.blockZ;
            relStepZ = (nextZ - this.z) / distToEndZ;
        }
        if (relStepX == -0.0) {
            relStepX = -1.0E-4;
        }
        if (relStepY == -0.0) {
            relStepY = -1.0E-4;
        }
        if (relStepZ == -0.0) {
            relStepZ = -1.0E-4;
        }
        if (relStepX <= relStepY && relStepX <= relStepZ) {
            this.side = positiveX ? class_2350.field_11039 : class_2350.field_11034;
            this.x = nextX;
            this.y += distToEndY * relStepX;
            this.z += distToEndZ * relStepX;
        } else if (relStepY <= relStepZ && relStepY <= relStepX) {
            this.side = positiveY ? class_2350.field_11033 : class_2350.field_11036;
            this.x += distToEndX * relStepY;
            this.y = nextY;
            this.z += distToEndZ * relStepY;
        } else {
            this.side = positiveZ ? class_2350.field_11043 : class_2350.field_11035;
            this.x += distToEndX * relStepZ;
            this.y += distToEndY * relStepZ;
            this.z = nextZ;
        }
        this.blockX = class_3532.method_15357((double)this.x) - (this.side == class_2350.field_11034 ? 1 : 0);
        this.blockY = class_3532.method_15357((double)this.y) - (this.side == class_2350.field_11036 ? 1 : 0);
        this.blockZ = class_3532.method_15357((double)this.z) - (this.side == class_2350.field_11035 ? 1 : 0);
        return false;
    }

    public class_243 getPosition() {
        return new class_243(this.x, this.y, this.z);
    }

    public class_2350 getSide() {
        return this.side;
    }

    public void getBlockPosition(LongConsumer consumer) {
        long pos = class_2338.method_10064((int)this.blockX, (int)this.blockY, (int)this.blockZ);
        consumer.accept(pos);
    }

    public void iterateAllPositions(LongConsumer consumer) {
        this.getBlockPosition(consumer);
        while (!this.advance()) {
            this.getBlockPosition(consumer);
        }
    }
}

